/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.lang.model.element.TypeElement;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class HistorySupport {
    public static final String HISTORY = "history";
    private static final int HISTORY_LENGTH = 25;
    private static Map<Class<?>, HistorySupport> instances = new HashMap();
    private final PropertyChangeSupport suppot = new PropertyChangeSupport(this);
    private final Deque<Pair<URI, ElementHandle<TypeElement>>> history = new ArrayDeque<Pair<URI, ElementHandle<TypeElement>>>();

    private HistorySupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToHistory(@NonNull Pair<URI, ElementHandle<TypeElement>> pair) {
        HistorySupport historySupport = this;
        synchronized (historySupport) {
            if (this.history.size() == 25) {
                this.history.removeLast();
            }
            boolean contains = false;
            for (Pair<URI, ElementHandle<TypeElement>> p : this.history) {
                if (!p.equals(pair)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                this.history.addFirst(pair);
            }
        }
        this.suppot.firePropertyChange(HISTORY, null, null);
    }

    @NonNull
    public synchronized List<? extends Pair<URI, ElementHandle<TypeElement>>> getHistory() {
        TreeSet<Pair<URI, ElementHandle<TypeElement>>> sorted = new TreeSet<Pair<URI, ElementHandle<TypeElement>>>(new SimpleNameAndPackageComparator());
        for (Pair<URI, ElementHandle<TypeElement>> p : this.history) {
            sorted.add(p);
        }
        return Collections.unmodifiableList(new ArrayList<Pair<URI, ElementHandle<TypeElement>>>(sorted));
    }

    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        assert (listener != null);
        this.suppot.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        assert (listener != null);
        this.suppot.removePropertyChangeListener(listener);
    }

    @NonNull
    public static synchronized HistorySupport getInstnace(@NonNull Class<?> forClass) {
        Parameters.notNull((CharSequence)"forClass", forClass);
        HistorySupport history = instances.get(forClass);
        if (history == null) {
            history = new HistorySupport();
            instances.put(forClass, history);
        }
        return history;
    }

    public static ComboBoxModel createModel(@NonNull HistorySupport support, @NullAllowed String emptyMessage) {
        return new HistoryModel(support, emptyMessage);
    }

    public static ListCellRenderer createRenderer(@NonNull HistorySupport support) {
        return new HistoryRenderer();
    }

    private static String getSimpleName(@NonNull String fqn) {
        int sepIndex = HistorySupport.splitIndex(fqn);
        return sepIndex >= 0 ? fqn.substring(sepIndex + 1) : fqn;
    }

    private static String getEnclosing(@NonNull String fqn) {
        int sepIndex = HistorySupport.splitIndex(fqn);
        return sepIndex >= 0 ? fqn.substring(0, sepIndex) : "";
    }

    private static int splitIndex(String fqn) {
        int sepIndex = fqn.lastIndexOf(36);
        if (sepIndex == -1) {
            sepIndex = fqn.lastIndexOf(46);
        }
        return sepIndex;
    }

    private static class SimpleNameAndPackageComparator
    implements Comparator<Pair<URI, ElementHandle<TypeElement>>> {
        private SimpleNameAndPackageComparator() {
        }

        @Override
        public int compare(Pair<URI, ElementHandle<TypeElement>> o1, Pair<URI, ElementHandle<TypeElement>> o2) {
            String simpleName2;
            String q1 = ((ElementHandle)o1.second()).getQualifiedName();
            String q2 = ((ElementHandle)o2.second()).getQualifiedName();
            String simpleName1 = HistorySupport.getSimpleName(q1);
            int res = simpleName1.compareTo(simpleName2 = HistorySupport.getSimpleName(q2));
            if (res != 0) {
                return res;
            }
            String pkg1 = HistorySupport.getEnclosing(q1);
            String pkg2 = HistorySupport.getEnclosing(q2);
            return pkg1.compareTo(pkg2);
        }
    }

    private static class HistoryModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private final List<ListDataListener> listeners;
        private final HistorySupport history;
        private final String emptyMessage;
        private List<?> cache;
        private Object selectedItem;

        HistoryModel(@NonNull HistorySupport history, @NonNull String emptyMessage) {
            Parameters.notNull((CharSequence)HistorySupport.HISTORY, (Object)history);
            this.listeners = new CopyOnWriteArrayList<ListDataListener>();
            this.history = history;
            this.emptyMessage = emptyMessage;
            this.history.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)history));
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem == null ? anItem != null : !this.selectedItem.equals(anItem)) {
                this.selectedItem = anItem;
                this.fire();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public int getSize() {
            return this.getCache().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.getCache().get(index);
        }

        @Override
        public void addListDataListener(@NonNull ListDataListener l) {
            assert (l != null);
            this.listeners.add(l);
        }

        @Override
        public void removeListDataListener(@NonNull ListDataListener l) {
            assert (l != null);
            this.listeners.remove(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (HistorySupport.HISTORY.equals(evt.getPropertyName())) {
                HistoryModel historyModel = this;
                synchronized (historyModel) {
                    this.cache = null;
                }
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        this.fire();
                    }
                });
            }
        }

        private void fire() {
            ListDataEvent event = new ListDataEvent(this, -1, -1, Integer.MAX_VALUE);
            for (ListDataListener l : this.listeners) {
                l.contentsChanged(event);
            }
        }

        @NonNull
        private synchronized List<?> getCache() {
            if (this.cache == null) {
                this.cache = this.history.getHistory();
                if (this.cache.isEmpty() && this.emptyMessage != null) {
                    this.cache = Collections.singletonList(this.emptyMessage);
                    this.setSelectedItem(this.emptyMessage);
                }
            }
            return this.cache;
        }
    }

    private static class HistoryRenderer
    extends DefaultListCellRenderer {
        private HistoryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String toolTipText = null;
            if (value instanceof Pair && ((Pair)value).second() instanceof ElementHandle) {
                String fqn = ((ElementHandle)((Pair)value).second()).getQualifiedName();
                value = HistorySupport.getSimpleName(fqn);
                toolTipText = fqn;
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setToolTipText(toolTipText);
            return c;
        }
    }
}

