/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class Xsd2Java {
    public static final String JAXB_SCRIPT_PATH = "modules/ext/build-jaxb.xml";
    public static final String PROP_XSD_FILE = "xsd.file";
    public static final String PROP_PACKAGE_NAME = "packageName";
    public static final String PROP_JAXB_BASE = "jaxb.base";
    public static final String PROP_JAXB_JAR = "jaxb.jar";
    public static final String PROP_JAXB_SRC_JAR = "jaxb.src.jar";
    public static final String PROP_USER_BUILD_PROPERTIES = "user.build.properties.file";
    private FileObject xsdFile;
    private String packageName;
    private String jaxbFolder;
    private String jaxbJarPath;
    private String jaxbSourceJarPath;

    public Xsd2Java(FileObject xsdFile, String packageName) {
        this.xsdFile = xsdFile;
        this.packageName = packageName;
        this.jaxbFolder = Xsd2Java.deriveJaxbBase(xsdFile);
        this.jaxbJarPath = Xsd2Java.deriveJaxbJarPath(xsdFile);
        this.jaxbSourceJarPath = Xsd2Java.deriveJaxbSourceJarPath(xsdFile);
    }

    private static String deriveJaxbBase(FileObject file) {
        return file.getName() + "-jaxb";
    }

    private static String deriveJaxbJarPath(FileObject file) {
        return file.getName() + ".jar";
    }

    private static String deriveJaxbSourceJarPath(FileObject file) {
        return file.getName() + "-src.jar";
    }

    public boolean compile() throws IOException {
        if (this.getJaxbJarFile() != null) {
            return true;
        }
        FileObject jaxbBaseDir = this.getOrCreateJaxbFolder();
        FileObject userBuildFile = SaasServicesModel.getWebServiceHome().getParent().getParent().getFileObject("build.properties");
        File jaxbBasePath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)jaxbBaseDir));
        File xsdFilePath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.xsdFile));
        File userBuildPath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)userBuildFile));
        Properties p = new Properties();
        p.setProperty(PROP_XSD_FILE, xsdFilePath.getPath());
        p.setProperty(PROP_PACKAGE_NAME, this.packageName);
        p.setProperty(PROP_JAXB_BASE, jaxbBasePath.getPath());
        p.setProperty(PROP_JAXB_JAR, this.jaxbJarPath);
        p.setProperty(PROP_JAXB_SRC_JAR, this.jaxbSourceJarPath);
        p.setProperty(PROP_USER_BUILD_PROPERTIES, userBuildPath.getPath());
        return this.createJaxBJar(p);
    }

    public boolean recompile() throws IOException {
        FileObject jaxbBaseDir = this.xsdFile.getParent().getFileObject(this.jaxbFolder);
        if (jaxbBaseDir != null) {
            jaxbBaseDir.delete();
        }
        return this.compile();
    }

    public FileObject getJaxbFolder() {
        return this.xsdFile.getParent().getFileObject(this.jaxbFolder);
    }

    public FileObject getOrCreateJaxbFolder() throws IOException {
        FileObject result = this.getJaxbFolder();
        if (result == null) {
            result = this.xsdFile.getParent().createFolder(this.jaxbFolder);
        }
        return result;
    }

    public FileObject getJaxbJarFile() {
        FileObject jaxbBaseDir = this.getJaxbFolder();
        if (jaxbBaseDir == null) {
            return null;
        }
        return jaxbBaseDir.getFileObject(this.jaxbJarPath);
    }

    public FileObject getJaxbSourceJarFile() {
        FileObject jaxbBaseDir = this.getJaxbFolder();
        if (jaxbBaseDir == null) {
            return null;
        }
        return jaxbBaseDir.getFileObject(this.jaxbSourceJarPath);
    }

    private boolean createJaxBJar(Properties properties) {
        try {
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"xjc-jar"}, (Properties)properties);
            executorTask.waitFinished();
            return executorTask.result() == 0;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private File getAntScript() {
        return InstalledFileLocator.getDefault().locate(JAXB_SCRIPT_PATH, "", false);
    }
}

