/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.object.CoreLocation;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.DefaultLayout;
import com.oracle.truffle.object.Flags;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import sun.misc.Unsafe;

class CoreAllocator
extends ShapeImpl.BaseAllocator {
    CoreAllocator(LayoutImpl layout) {
        super(layout);
    }

    CoreAllocator(ShapeImpl shape) {
        super(shape);
    }

    private DefaultLayout getLayout() {
        return (DefaultLayout)this.layout;
    }

    @Override
    public CoreLocation constantLocation(Object value) {
        return new CoreLocations.ConstantLocation(value);
    }

    @Override
    public CoreLocation declaredLocation(Object value) {
        return new CoreLocations.DeclaredLocation(value);
    }

    @Override
    protected Location moveLocation(Location oldLocation) {
        if (oldLocation instanceof CoreLocations.LongLocation) {
            return this.newLongLocation(oldLocation.isFinal(), ((CoreLocations.LongLocation)((Object)oldLocation)).isImplicitCastIntToLong());
        }
        if (oldLocation instanceof CoreLocations.IntLocation) {
            return this.newIntLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof CoreLocations.DoubleLocation) {
            return this.newDoubleLocation(oldLocation.isFinal(), ((CoreLocations.DoubleLocation)((Object)oldLocation)).isImplicitCastIntToDouble());
        }
        if (oldLocation instanceof CoreLocations.BooleanLocation) {
            return this.newBooleanLocation(oldLocation.isFinal());
        }
        if (oldLocation instanceof CoreLocations.ObjectLocation) {
            return this.newObjectLocation(oldLocation.isFinal(), ((CoreLocations.ObjectLocation)((Object)oldLocation)).isNonNull());
        }
        assert (oldLocation instanceof CoreLocations.ValueLocation) : oldLocation;
        return this.advance(oldLocation);
    }

    @Override
    public Location newObjectLocation(boolean useFinal, boolean nonNull) {
        int insertPos;
        if (ObjectStorageOptions.InObjectFields && (insertPos = this.objectFieldSize) + 1 <= this.getLayout().getObjectFieldCount()) {
            return this.advance((Location)((Object)this.getLayout().getObjectFieldLocation(insertPos)));
        }
        return this.newObjectArrayLocation(useFinal, nonNull);
    }

    private Location newObjectArrayLocation(boolean useFinal, boolean nonNull) {
        return this.advance(new CoreLocations.ObjectArrayLocation(this.objectArraySize));
    }

    @Override
    public Location newTypedObjectLocation(boolean useFinal, Class<?> type, boolean nonNull) {
        return this.newObjectLocation(useFinal, nonNull);
    }

    @Override
    protected Location newIntLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.IntegerLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new CoreLocations.IntLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.IntLocationDecorator(new CoreLocations.LongArrayLocation(alignedIndex)));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newDoubleLocation(boolean useFinal) {
        return this.newDoubleLocation(useFinal, this.getLayout().isAllowedIntToDouble());
    }

    Location newDoubleLocation(boolean useFinal, boolean allowedIntToDouble) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.DoubleLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance(new CoreLocations.DoubleLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), allowedIntToDouble));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.DoubleLocationDecorator(new CoreLocations.LongArrayLocation(alignedIndex), allowedIntToDouble));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newLongLocation(boolean useFinal) {
        return this.newLongLocation(useFinal, this.getLayout().isAllowedIntToLong());
    }

    Location newLongLocation(boolean useFinal, boolean allowedIntToLong) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.LongLocations) {
            if (ObjectStorageOptions.InObjectFields && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
                return this.advance((Location)((Object)CoreLocations.createLongLocation(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize), allowedIntToLong)));
            }
            if (this.getLayout().hasPrimitiveExtensionArray()) {
                int alignedIndex = CoreAllocator.alignArrayIndex(this.primitiveArraySize, 8);
                return this.advance(new CoreLocations.LongArrayLocation(alignedIndex, allowedIntToLong));
            }
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    public Location newBooleanLocation(boolean useFinal) {
        if (ObjectStorageOptions.PrimitiveLocations && ObjectStorageOptions.BooleanLocations && this.primitiveFieldSize + this.getLayout().getLongFieldSize() <= this.getLayout().getPrimitiveFieldCount()) {
            return this.advance(new CoreLocations.BooleanLocationDecorator(this.getLayout().getPrimitiveFieldLocation(this.primitiveFieldSize)));
        }
        return this.newObjectLocation(useFinal, true);
    }

    @Override
    protected Location locationForValue(Object value, boolean useFinal, boolean nonNull) {
        return this.locationForValue(value, useFinal, nonNull, 0L);
    }

    Location locationForValue(Object value, boolean useFinal, boolean nonNull, long putFlags) {
        if (Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        if (Flags.isDeclaration(putFlags)) {
            return this.declaredLocation(value);
        }
        if (value instanceof Integer) {
            return this.newIntLocation(useFinal);
        }
        if (value instanceof Double) {
            return this.newDoubleLocation(useFinal, Flags.isImplicitCastIntToDouble(putFlags) || this.layout.isAllowedIntToDouble());
        }
        if (value instanceof Long) {
            return this.newLongLocation(useFinal, Flags.isImplicitCastIntToLong(putFlags) || this.layout.isAllowedIntToLong());
        }
        if (value instanceof Boolean) {
            return this.newBooleanLocation(useFinal);
        }
        if (ObjectStorageOptions.TypedObjectLocations && value != null) {
            return this.newTypedObjectLocation(useFinal, value.getClass(), nonNull);
        }
        return this.newObjectLocation(useFinal, nonNull && value != null);
    }

    @Override
    protected Location locationForType(Class<?> type, boolean useFinal, boolean nonNull) {
        if (type == Integer.TYPE) {
            return this.newIntLocation(useFinal);
        }
        if (type == Double.TYPE) {
            return this.newDoubleLocation(useFinal);
        }
        if (type == Long.TYPE) {
            return this.newLongLocation(useFinal);
        }
        if (type == Boolean.TYPE) {
            return this.newBooleanLocation(useFinal);
        }
        if (ObjectStorageOptions.TypedObjectLocations && type != null && type != Object.class) {
            assert (!type.isPrimitive()) : "unsupported primitive type";
            return this.newTypedObjectLocation(useFinal, type, nonNull);
        }
        return this.newObjectLocation(useFinal, nonNull);
    }

    @Override
    protected Location locationForValueUpcast(Object value, Location oldLocation, long putFlags) {
        assert (!oldLocation.canStore(value));
        if (oldLocation instanceof CoreLocations.ConstantLocation && Flags.isConstant(putFlags)) {
            return this.constantLocation(value);
        }
        if (oldLocation instanceof CoreLocations.ValueLocation) {
            return this.locationForValue(value, false, value != null);
        }
        if (oldLocation instanceof CoreLocations.TypedLocation && ((CoreLocations.TypedLocation)((Object)oldLocation)).getType().isPrimitive()) {
            if (!this.shared && ((CoreLocations.TypedLocation)((Object)oldLocation)).getType() == Integer.TYPE) {
                boolean allowedIntToDouble;
                CoreLocations.LongLocation primLocation = ((CoreLocations.PrimitiveLocationDecorator)oldLocation).getInternalLongLocation();
                boolean allowedIntToLong = this.layout.isAllowedIntToLong() || Flags.isImplicitCastIntToLong(putFlags);
                boolean bl = allowedIntToDouble = this.layout.isAllowedIntToDouble() || Flags.isImplicitCastIntToDouble(putFlags);
                if (allowedIntToLong && value instanceof Long) {
                    return new CoreLocations.LongLocationDecorator(primLocation, true);
                }
                if (allowedIntToDouble && value instanceof Double) {
                    return new CoreLocations.DoubleLocationDecorator(primLocation, true);
                }
            }
            return this.newObjectLocation(oldLocation.isFinal(), value != null);
        }
        return this.locationForValue(value, false, value != null);
    }

    private static int alignArrayIndex(int index, int bytes) {
        assert (bytes > 0 && (bytes & bytes - 1) == 0);
        int baseOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int indexScale = Unsafe.ARRAY_INT_INDEX_SCALE;
        if (bytes <= indexScale) {
            return index;
        }
        int misalignment = baseOffset + indexScale * index & bytes - 1;
        if (misalignment == 0) {
            return index;
        }
        return index + (bytes - misalignment) / indexScale;
    }
}

