/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.maker;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.GeoPolygonQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.RegexpFlag;
import org.opensearch.index.query.RegexpQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.join.query.JoinQueryBuilders;
import org.opensearch.script.Script;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Paramer;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.parser.ScriptFilter;
import org.opensearch.sql.legacy.parser.SubQueryExpression;
import org.opensearch.sql.legacy.parser.WhereParser;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.sql.legacy.spatial.BoundingBoxFilterParams;
import org.opensearch.sql.legacy.spatial.DistanceFilterParams;
import org.opensearch.sql.legacy.spatial.Point;
import org.opensearch.sql.legacy.spatial.PolygonFilterParams;
import org.opensearch.sql.legacy.spatial.WktToGeoJsonConverter;
import org.opensearch.sql.legacy.utils.StringUtils;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.Sets;

public abstract class Maker {
    private static final ZoneId UTC = ZoneId.of("UTC");
    public static final Object NONE = new Object();
    public static final Set<String> queryFunctions = Sets.newHashSet((Object[])new String[]{"query", "matchquery", "match_query", "multimatchquery", "multi_match", "multimatch", "score", "scorequery", "score_query", "wildcardquery", "wildcard_query", "matchphrasequery", "match_phrase", "matchphrase"});
    private static final Set<Condition.OPERATOR> NOT_OPERATOR_SET = ImmutableSet.of((Object)((Object)Condition.OPERATOR.N), (Object)((Object)Condition.OPERATOR.NIN), (Object)((Object)Condition.OPERATOR.ISN), (Object)((Object)Condition.OPERATOR.NBETWEEN), (Object)((Object)Condition.OPERATOR.NLIKE), (Object)((Object)Condition.OPERATOR.NIN_TERMS), (Object[])new Condition.OPERATOR[]{Condition.OPERATOR.NTERM, Condition.OPERATOR.NOT_EXISTS_NESTED_COMPLEX, Condition.OPERATOR.NREGEXP});

    protected Maker(Boolean isQuery) {
    }

    protected ToXContent make(Condition cond) throws SqlParseException {
        String name = cond.getName();
        Object value = cond.getValue();
        Object toXContent = null;
        toXContent = value instanceof SQLMethodInvokeExpr ? this.make(cond, name, (SQLMethodInvokeExpr)value) : (value instanceof SubQueryExpression ? this.make(cond, name, ((SubQueryExpression)value).getValues()) : (cond.getValue() == NONE ? new MatchNoneQueryBuilder() : this.make(cond, name, value)));
        return toXContent;
    }

    private ToXContent make(Condition cond, String name, SQLMethodInvokeExpr value) throws SqlParseException {
        ToXContent bqb = null;
        Paramer paramer = null;
        switch (value.getMethodName().toLowerCase()) {
            case "query": {
                paramer = Paramer.parseParamer(value);
                QueryStringQueryBuilder queryString = QueryBuilders.queryStringQuery((String)paramer.value);
                bqb = Paramer.fullParamer(queryString, paramer);
                bqb = this.applyNot(cond.getOPERATOR(), bqb);
                break;
            }
            case "matchquery": 
            case "match_query": {
                paramer = Paramer.parseParamer(value);
                MatchQueryBuilder matchQuery = QueryBuilders.matchQuery((String)name, (Object)paramer.value);
                bqb = Paramer.fullParamer(matchQuery, paramer);
                bqb = this.applyNot(cond.getOPERATOR(), bqb);
                break;
            }
            case "score": 
            case "scorequery": 
            case "score_query": {
                Float boost = Float.valueOf(Float.parseFloat(((SQLExpr)value.getParameters().get(1)).toString()));
                Condition subCond = WhereParser.getConditionForMethod((SQLExpr)value.getParameters().get(0), cond.getConn());
                QueryBuilder subQuery = (QueryBuilder)this.make(subCond);
                if (subCond.isNested()) {
                    subQuery = QueryBuilders.nestedQuery((String)subCond.getNestedPath(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
                }
                bqb = QueryBuilders.constantScoreQuery((QueryBuilder)subQuery).boost(boost.floatValue());
                break;
            }
            case "wildcardquery": 
            case "wildcard_query": {
                paramer = Paramer.parseParamer(value);
                WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)name, (String)paramer.value);
                bqb = Paramer.fullParamer(wildcardQuery, paramer);
                break;
            }
            case "matchphrasequery": 
            case "match_phrase": 
            case "matchphrase": {
                paramer = Paramer.parseParamer(value);
                MatchPhraseQueryBuilder matchPhraseQuery = QueryBuilders.matchPhraseQuery((String)name, (Object)paramer.value);
                bqb = Paramer.fullParamer(matchPhraseQuery, paramer);
                break;
            }
            case "multimatchquery": 
            case "multi_match": 
            case "multimatch": {
                paramer = Paramer.parseParamer(value);
                MultiMatchQueryBuilder multiMatchQuery = QueryBuilders.multiMatchQuery((Object)paramer.value, (String[])new String[0]).fields(paramer.fieldsBoosts);
                bqb = Paramer.fullParamer(multiMatchQuery, paramer);
                break;
            }
            default: {
                throw new SqlParseException("The following query method is not supported: " + value.getMethodName());
            }
        }
        return bqb;
    }

    private ToXContent make(Condition cond, String name, Object value) throws SqlParseException {
        RangeQueryBuilder toXContent = null;
        switch (cond.getOPERATOR()) {
            case ISN: 
            case IS: 
            case N: 
            case EQ: {
                if (value == null || value instanceof SQLIdentifierExpr) {
                    if (value == null || ((SQLIdentifierExpr)value).getName().equalsIgnoreCase("missing")) {
                        toXContent = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)name));
                        break;
                    }
                    throw new SqlParseException(String.format("Cannot recoginze Sql identifer %s", ((SQLIdentifierExpr)value).getName()));
                }
                toXContent = QueryBuilders.termQuery((String)name, (Object)value);
                break;
            }
            case LIKE: 
            case NLIKE: {
                String queryStr = (String)value;
                queryStr = queryStr.replace('%', '*').replace('_', '?');
                queryStr = queryStr.replace("&PERCENT", "%").replace("&UNDERSCORE", "_");
                toXContent = QueryBuilders.wildcardQuery((String)name, (String)queryStr);
                break;
            }
            case REGEXP: 
            case NREGEXP: {
                Object[] values = (Object[])value;
                RegexpQueryBuilder regexpQuery = QueryBuilders.regexpQuery((String)name, (String)values[0].toString());
                if (1 < values.length) {
                    String[] flags = values[1].toString().split("\\|");
                    RegexpFlag[] regexpFlags = new RegexpFlag[flags.length];
                    for (int i = 0; i < flags.length; ++i) {
                        regexpFlags[i] = RegexpFlag.valueOf((String)flags[i]);
                    }
                    regexpQuery.flags(regexpFlags);
                }
                if (2 < values.length) {
                    regexpQuery.maxDeterminizedStates(Integer.parseInt(values[2].toString()));
                }
                toXContent = regexpQuery;
                break;
            }
            case GT: {
                toXContent = QueryBuilders.rangeQuery((String)name).gt(value);
                break;
            }
            case GTE: {
                toXContent = QueryBuilders.rangeQuery((String)name).gte(value);
                break;
            }
            case LT: {
                toXContent = QueryBuilders.rangeQuery((String)name).lt(value);
                break;
            }
            case LTE: {
                toXContent = QueryBuilders.rangeQuery((String)name).lte(value);
                break;
            }
            case NIN: 
            case IN: {
                Object[] values = (Object[])value;
                TermQueryBuilder[] termQueries = new TermQueryBuilder[values.length];
                for (int i = 0; i < values.length; ++i) {
                    termQueries[i] = QueryBuilders.termQuery((String)name, (Object)values[i]);
                }
                BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
                for (TermQueryBuilder termQuery : termQueries) {
                    boolQuery.should((QueryBuilder)termQuery);
                }
                toXContent = boolQuery;
                break;
            }
            case BETWEEN: 
            case NBETWEEN: {
                toXContent = QueryBuilders.rangeQuery((String)name).gte(((Object[])value)[0]).lte(((Object[])value)[1]);
                break;
            }
            case GEO_INTERSECTS: {
                String wkt = cond.getValue().toString();
                try {
                    ShapeBuilder shapeBuilder = this.getShapeBuilderFromString(wkt);
                    toXContent = QueryBuilders.geoShapeQuery((String)cond.getName(), (ShapeBuilder)shapeBuilder);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new SqlParseException(StringUtils.format("Failed to create shapeBuilder from [%s]", wkt));
                }
            }
            case GEO_BOUNDING_BOX: {
                BoundingBoxFilterParams boxFilterParams = (BoundingBoxFilterParams)cond.getValue();
                Point topLeft = boxFilterParams.getTopLeft();
                Point bottomRight = boxFilterParams.getBottomRight();
                toXContent = QueryBuilders.geoBoundingBoxQuery((String)cond.getName()).setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
                break;
            }
            case GEO_DISTANCE: {
                DistanceFilterParams distanceFilterParams = (DistanceFilterParams)cond.getValue();
                Point fromPoint = distanceFilterParams.getFrom();
                String distance = this.trimApostrophes(distanceFilterParams.getDistance());
                toXContent = QueryBuilders.geoDistanceQuery((String)cond.getName()).distance(distance).point(fromPoint.getLat(), fromPoint.getLon());
                break;
            }
            case GEO_POLYGON: {
                PolygonFilterParams polygonFilterParams = (PolygonFilterParams)cond.getValue();
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (Point p : polygonFilterParams.getPolygon()) {
                    geoPoints.add(new GeoPoint(p.getLat(), p.getLon()));
                }
                GeoPolygonQueryBuilder polygonFilterBuilder = QueryBuilders.geoPolygonQuery((String)cond.getName(), geoPoints);
                toXContent = polygonFilterBuilder;
                break;
            }
            case NIN_TERMS: 
            case IN_TERMS: {
                Object[] termValues = (Object[])value;
                if (termValues.length == 1 && termValues[0] instanceof SubQueryExpression) {
                    termValues = ((SubQueryExpression)termValues[0]).getValues();
                }
                Object[] termValuesObjects = new Object[termValues.length];
                for (int i = 0; i < termValues.length; ++i) {
                    termValuesObjects[i] = this.parseTermValue(termValues[i]);
                }
                toXContent = QueryBuilders.termsQuery((String)name, (Object[])termValuesObjects);
                break;
            }
            case NTERM: 
            case TERM: {
                Object term = ((Object[])value)[0];
                toXContent = QueryBuilders.termQuery((String)name, (Object)this.parseTermValue(term));
                break;
            }
            case IDS_QUERY: {
                String[] ids;
                Object[] idsParameters = (Object[])value;
                if (idsParameters.length == 2 && idsParameters[1] instanceof SubQueryExpression) {
                    Object[] idsFromSubQuery = ((SubQueryExpression)idsParameters[1]).getValues();
                    ids = this.arrayOfObjectsToStringArray(idsFromSubQuery, 0, idsFromSubQuery.length - 1);
                } else {
                    ids = this.arrayOfObjectsToStringArray(idsParameters, 1, idsParameters.length - 1);
                }
                toXContent = QueryBuilders.idsQuery().addIds(ids);
                break;
            }
            case NESTED_COMPLEX: 
            case NOT_EXISTS_NESTED_COMPLEX: {
                if (value == null || !(value instanceof Where)) {
                    throw new SqlParseException("unsupported nested condition");
                }
                Where whereNested = (Where)value;
                BoolQueryBuilder nestedFilter = QueryMaker.explain(whereNested);
                toXContent = QueryBuilders.nestedQuery((String)name, (QueryBuilder)nestedFilter, (ScoreMode)ScoreMode.None);
                break;
            }
            case CHILDREN_COMPLEX: {
                if (value == null || !(value instanceof Where)) {
                    throw new SqlParseException("unsupported nested condition");
                }
                Where whereChildren = (Where)value;
                BoolQueryBuilder childrenFilter = QueryMaker.explain(whereChildren);
                toXContent = JoinQueryBuilders.hasChildQuery((String)name, (QueryBuilder)childrenFilter, (ScoreMode)ScoreMode.None);
                break;
            }
            case SCRIPT: {
                ScriptFilter scriptFilter = (ScriptFilter)value;
                Map<Object, Object> params = new HashMap();
                if (scriptFilter.containsParameters()) {
                    params = scriptFilter.getArgs();
                }
                SQLExpr nameExpr = cond.getNameExpr();
                SQLExpr valueExpr = cond.getValueExpr();
                if (nameExpr instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)nameExpr).getMethodName().equalsIgnoreCase("date_format")) {
                    toXContent = this.makeForDateFormat((SQLMethodInvokeExpr)nameExpr, (SQLCharExpr)valueExpr);
                    break;
                }
                toXContent = QueryBuilders.scriptQuery((Script)new Script(scriptFilter.getScriptType(), "painless", scriptFilter.getScript(), params));
                break;
            }
            default: {
                throw new SqlParseException("Undefined condition:  " + cond.getName());
            }
        }
        toXContent = this.applyNot(cond.getOPERATOR(), (ToXContent)toXContent);
        return toXContent;
    }

    public static boolean isQueryFunction(String methodName) {
        return queryFunctions.contains(methodName.toLowerCase());
    }

    private ToXContent makeForDateFormat(SQLMethodInvokeExpr nameExpr, SQLCharExpr valueExpr) throws SqlParseException {
        RangeQueryBuilder toXContent = null;
        List params = nameExpr.getParameters();
        String field = ((SQLExpr)params.get(0)).toString();
        String format = this.removeSingleQuote(((SQLExpr)params.get(1)).toString());
        String dateToCompare = valueExpr.getText();
        String oper = ((SQLBinaryOpExpr)nameExpr.getParent()).getOperator().name;
        String zoneId = params.size() > 2 ? ZoneId.of(this.removeSingleQuote(((SQLExpr)params.get(2)).toString())).toString() : UTC.getId();
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)field).format(format).timeZone(zoneId);
        switch (oper) {
            case "<>": 
            case "=": {
                toXContent = rangeQuery.gte((Object)dateToCompare).lte((Object)dateToCompare);
                break;
            }
            case ">": {
                toXContent = rangeQuery.gt((Object)dateToCompare);
                break;
            }
            case "<": {
                toXContent = rangeQuery.lt((Object)dateToCompare);
                break;
            }
            case ">=": {
                toXContent = rangeQuery.gte((Object)dateToCompare);
                break;
            }
            case "<=": {
                toXContent = rangeQuery.lte((Object)dateToCompare);
                break;
            }
            case "BETWEEN": 
            case "NOT BETWEEN": {
                break;
            }
            default: {
                throw new SqlParseException("date_format does not support the operation " + oper);
            }
        }
        toXContent = this.applyNot(Condition.OPERATOR.operStringToOpear.get(oper), (ToXContent)toXContent);
        return toXContent;
    }

    private String removeSingleQuote(String param) {
        return param.replaceAll("'", "");
    }

    private String[] arrayOfObjectsToStringArray(Object[] values, int from, int to) {
        String[] strings = new String[to - from + 1];
        int counter = 0;
        for (int i = from; i <= to; ++i) {
            strings[counter] = values[i].toString();
            ++counter;
        }
        return strings;
    }

    private ShapeBuilder getShapeBuilderFromString(String str) throws IOException, SqlParseException {
        String json = str.contains("{") ? this.fixJsonFromElastic(str) : WktToGeoJsonConverter.toGeoJson(this.trimApostrophes(str));
        return this.getShapeBuilderFromJson(json);
    }

    private String fixJsonFromElastic(String elasticJson) {
        String properJson = elasticJson.replaceAll("=", ":");
        properJson = properJson.replaceAll("(type)(:)([a-zA-Z]+)", "\"type\":\"$3\"");
        properJson = properJson.replaceAll("coordinates", "\"coordinates\"");
        return properJson;
    }

    private ShapeBuilder getShapeBuilderFromJson(String json) throws IOException {
        XContentParser parser = null;
        parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, json);
        parser.nextToken();
        return ShapeParser.parse((XContentParser)parser);
    }

    private String trimApostrophes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private ToXContent applyNot(Condition.OPERATOR OPERATOR2, ToXContent bqb) {
        if (NOT_OPERATOR_SET.contains((Object)OPERATOR2)) {
            bqb = QueryBuilders.boolQuery().mustNot((QueryBuilder)bqb);
        }
        return bqb;
    }

    private Object parseTermValue(Object termValue) {
        if (termValue instanceof SQLNumericLiteralExpr) {
            if ((termValue = ((SQLNumericLiteralExpr)termValue).getNumber()) instanceof BigDecimal || termValue instanceof Double) {
                termValue = ((Number)termValue).doubleValue();
            } else if (termValue instanceof Float) {
                termValue = Float.valueOf(((Number)termValue).floatValue());
            } else if (termValue instanceof BigInteger || termValue instanceof Long) {
                termValue = ((Number)termValue).longValue();
            } else if (termValue instanceof Integer) {
                termValue = ((Number)termValue).intValue();
            } else if (termValue instanceof Short) {
                termValue = ((Number)termValue).shortValue();
            } else if (termValue instanceof Byte) {
                termValue = ((Number)termValue).byteValue();
            }
        } else {
            termValue = termValue instanceof SQLBooleanExpr ? Boolean.valueOf(((SQLBooleanExpr)termValue).getValue()) : termValue.toString();
        }
        return termValue;
    }
}

