/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan.context;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.opensearch.storage.scan.AbstractCalciteIndexScan;

public class SortExprDigest {
    private final RexNode expression;
    private final String fieldName;
    private final RelFieldCollation.Direction direction;
    private final RelFieldCollation.NullDirection nullDirection;

    public SortExprDigest(RexNode expression, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        this(expression, null, direction, nullDirection);
    }

    public SortExprDigest(String fieldName, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        this(null, fieldName, direction, nullDirection);
    }

    public boolean isSimpleFieldReference() {
        return this.expression == null && !StringUtils.isEmpty((CharSequence)this.fieldName);
    }

    public RexNode getEffectiveExpression(AbstractCalciteIndexScan scan) {
        if (this.isSimpleFieldReference()) {
            List currentFieldNames = scan.getRowType().getFieldNames();
            int fieldIndex = currentFieldNames.indexOf(this.fieldName);
            if (fieldIndex >= 0) {
                return scan.getCluster().getRexBuilder().makeInputRef(((RelDataTypeField)scan.getRowType().getFieldList().get(fieldIndex)).getType(), fieldIndex);
            }
            return null;
        }
        return this.expression;
    }

    public String toString() {
        String sortTarget = this.isSimpleFieldReference() ? this.fieldName : this.expression.toString();
        return String.format("%s %s NULLS_%s", sortTarget, this.direction.toString(), this.nullDirection.toString());
    }

    public boolean isMissingMax() {
        return this.direction == RelFieldCollation.Direction.ASCENDING ^ this.nullDirection == RelFieldCollation.NullDirection.FIRST;
    }

    @Generated
    public RexNode getExpression() {
        return this.expression;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public RelFieldCollation.Direction getDirection() {
        return this.direction;
    }

    @Generated
    public RelFieldCollation.NullDirection getNullDirection() {
        return this.nullDirection;
    }

    @Generated
    public SortExprDigest(RexNode expression, String fieldName, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection) {
        this.expression = expression;
        this.fieldName = fieldName;
        this.direction = direction;
        this.nullDirection = nullDirection;
    }
}

