/// <reference types="react" />
import { ImmutableExecuteResult } from "@nteract/commutable";
import { RichMediaProps } from "./rich-media";
interface Props {
    /**
     * The literal type of output, used for routing with the `<Output />` element
     */
    output_type: "execute_result";
    output?: ImmutableExecuteResult;
    /**
     * React elements that accept media bundle data, will get passed `data[mediaType]`
     */
    children: RichMediaProps["children"];
}
export declare const ExecuteResult: {
    (props: Partial<Props>): JSX.Element | null;
    defaultProps: {
        output: null;
        output_type: string;
    };
};
export default ExecuteResult;
