/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.utils;

import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtPlatform;

public final class PackageInfo {
    public Version version;

    private static int maybeParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public PackageInfo() {
        CrtPlatform platform = CRT.getPlatformImpl();
        if (platform != null) {
            this.version = platform.getVersion();
            return;
        }
        Package pkg = CRT.class.getPackage();
        String pkgVersion = pkg.getSpecificationVersion();
        if (pkgVersion == null) {
            pkgVersion = pkg.getImplementationVersion();
        }
        if (pkgVersion == null) {
            pkgVersion = "0.0.0-UNITTEST";
        }
        this.version = new Version(pkgVersion);
    }

    public static class Version {
        private final String version;
        public final int major;
        public final int minor;
        public final int patch;
        public final String tag;

        public Version(String v) {
            this.version = v != null ? v : "UNKNOWN";
            int dashIdx = this.version.indexOf(45);
            this.tag = dashIdx != -1 ? this.version.substring(dashIdx + 1) : "";
            v = this.version.replace("-.+$", "");
            String[] parts = v.split("\\.", 3);
            int len = parts.length;
            this.patch = len > 2 ? PackageInfo.maybeParse(parts[2]) : 0;
            this.minor = len > 1 ? PackageInfo.maybeParse(parts[1]) : 0;
            this.major = len > 0 ? PackageInfo.maybeParse(parts[0]) : 0;
        }

        public String toString() {
            return this.version;
        }
    }
}

