/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.ip2geo.action.PutDatasourceAction;
import org.opensearch.geospatial.ip2geo.action.PutDatasourceRequest;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.common.URLDenyListChecker;
import org.opensearch.geospatial.shared.URLBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutDatasourceHandler
extends BaseRestHandler {
    private static final String ACTION_NAME = "ip2geo_datasource_put";
    private final ClusterSettings clusterSettings;
    private final URLDenyListChecker urlDenyListChecker;

    public RestPutDatasourceHandler(ClusterSettings clusterSettings, URLDenyListChecker urlDenyListChecker) {
        this.clusterSettings = clusterSettings;
        this.urlDenyListChecker = urlDenyListChecker;
    }

    public String getName() {
        return ACTION_NAME;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutDatasourceRequest putDatasourceRequest = new PutDatasourceRequest(request.param("name"));
        if (request.hasContentOrSourceParam()) {
            try (XContentParser parser = request.contentOrSourceParamParser();){
                PutDatasourceRequest.PARSER.parse(parser, (Object)putDatasourceRequest, null);
            }
        }
        if (putDatasourceRequest.getEndpoint() == null) {
            putDatasourceRequest.setEndpoint((String)this.clusterSettings.get(Ip2GeoSettings.DATASOURCE_ENDPOINT));
        }
        if (putDatasourceRequest.getUpdateInterval() == null) {
            putDatasourceRequest.setUpdateInterval(TimeValue.timeValueDays((long)((Long)this.clusterSettings.get(Ip2GeoSettings.DATASOURCE_UPDATE_INTERVAL))));
        }
        this.urlDenyListChecker.toUrlIfNotInDenyList(putDatasourceRequest.getEndpoint());
        return channel -> client.executeLocally((ActionType)PutDatasourceAction.INSTANCE, (ActionRequest)putDatasourceRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        String path = String.join((CharSequence)"/", URLBuilder.getPluginURLPrefix(), "ip2geo/datasource/{name}");
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, path));
    }
}

