/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class UsersTableModel
extends AbstractMultipleOptionsTableModel<User> {
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("users.table.header.enabled"), Constant.messages.getString("users.table.header.id"), Constant.messages.getString("users.table.header.name")};
    private static final long serialVersionUID = 4463944219657112162L;
    private List<User> users;

    public UsersTableModel(List<User> users) {
        this.users = new ArrayList<User>(users);
    }

    public UsersTableModel() {
        this.users = new ArrayList<User>();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.users.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.users.get(rowIndex).isEnabled();
            }
            case 1: {
                return this.users.get(rowIndex).getId();
            }
            case 2: {
                return this.users.get(rowIndex).getName();
            }
        }
        return null;
    }

    @Override
    public List<User> getElements() {
        return this.users;
    }

    public List<User> getUsers() {
        return this.users;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void setUsers(List<User> users) {
        this.users = new ArrayList<User>(users);
        this.fireTableDataChanged();
    }

    public void removeAllUsers() {
        this.users = new ArrayList<User>();
        this.fireTableDataChanged();
    }

    public void addUser(User user) {
        this.users.add(user);
        this.fireTableRowsInserted(this.users.size() - 1, this.users.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Boolean) {
            this.users.get(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

