# frozen_string_literal: true

class CreateVulnerabilityTriggeredWorkflows < Gitlab::Database::Migration[2.3]
  milestone '18.6'

  def change
    create_table :vulnerability_triggered_workflows do |t| # rubocop:disable Migration/EnsureFactoryForTable -- Has factory named triggered_workflows
      t.timestamps_with_timezone null: false

      t.references :vulnerability_occurrence,
        null: false,
        foreign_key: { on_delete: :cascade },
        index: { name: 'index_vulnerability_workflows_on_vuln_occurrence_id' }
      t.bigint :workflow_id, null: false
      t.bigint :project_id, null: false
      t.integer :workflow_name, null: false, default: 0, limit: 2

      t.index :workflow_id
      t.index :project_id
    end
  end
end
