/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.Beans;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Utilities;

public class IndexedPropertySupport<T, E>
extends Node.IndexedProperty<T, E> {
    protected Object instance;
    private Method setter;
    private Method getter;
    private Method indexedSetter;
    private Method indexedGetter;

    public IndexedPropertySupport(Object object, Class<T> clazz, Class<E> clazz2, Method method, Method method2, Method method3, Method method4) {
        super(clazz, clazz2);
        this.instance = object;
        this.setter = method2;
        this.getter = method;
        this.indexedSetter = method4;
        this.indexedGetter = method3;
    }

    @Override
    public final void setDisplayName(String string) {
        super.setDisplayName(string);
    }

    @Override
    public final void setName(String string) {
        super.setName(string);
    }

    @Override
    public final void setShortDescription(String string) {
        super.setShortDescription(string);
    }

    @Override
    public boolean canRead() {
        return this.getter != null;
    }

    @Override
    public T getValue() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canRead()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.getter.getDeclaringClass());
        return PropertySupport.cast(this.getValueType(), this.getter.invoke(object, new Object[0]));
    }

    @Override
    public boolean canWrite() {
        return this.setter != null;
    }

    @Override
    public void setValue(T t) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canWrite()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.setter.getDeclaringClass());
        Object object2 = t;
        if (t != null && this.setter.getParameterTypes()[0].getComponentType().isPrimitive() && !t.getClass().getComponentType().isPrimitive()) {
            object2 = Utilities.toPrimitiveArray((Object[])((Object[])t));
        }
        this.setter.invoke(object, object2);
    }

    @Override
    public boolean canIndexedRead() {
        return this.indexedGetter != null;
    }

    @Override
    public E getIndexedValue(int n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedRead()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.indexedGetter.getDeclaringClass());
        return PropertySupport.cast(this.getElementType(), this.indexedGetter.invoke(object, n));
    }

    @Override
    public boolean canIndexedWrite() {
        return this.indexedSetter != null;
    }

    @Override
    public void setIndexedValue(int n, E e) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.canIndexedWrite()) {
            throw new IllegalAccessException();
        }
        Object object = Beans.getInstanceOf(this.instance, this.indexedSetter.getDeclaringClass());
        this.indexedSetter.invoke(object, new Integer(n), e);
    }
}

