/******************************************************************************
 * (c) Copyright 2002,2004, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ConfigToClientBindingsAspect.java,v $
 * Version:       $Name:  $ $Revision: 1.5 $
 * Last Modified: $Date: 2004/06/21 12:19:33 $
 *****************************************************************************/
package org.ten60.netkernel.ws.soap.client;

import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.IAspectBinaryStream;
import com.ten60.netkernel.util.NetKernelException;

import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.DependencyMeta;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;

import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.xml.transrepresentation.DOMXDAParser;
import org.ten60.netkernel.xml.xda.*;

/**
 * ConfigToClientBindingsAspect- a transreptor to make a SOAPClientBindings configuration accessible as a IAspectSOAPClientBindings
 * @author  pjr
 */
public class ConfigToClientBindingsAspect extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return (aFrom.hasAspect(IXAspect.class) || aFrom.hasAspect(IAspectBinaryStream.class)) 
			&& aTo.isAssignableFrom(IAspectSOAPClientBindings.class);
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	
			if (!aFrom.hasAspect(IXAspect.class))
			{	// transreptor pipelining not implement so we must do it ourselves
				DOMXDAParser dxp = new DOMXDAParser();
				aFrom = dxp.transrepresent(aFrom);
			}
			IXDAReadOnly from = ((IXAspect)aFrom.getAspect(IXAspect.class)).getXDA();
			IXDAReadOnlyIterator it=from.readOnlyIterator("/SOAPClientBindings/binding");
			ClientBindingsAspect cba=new ClientBindingsAspect();
			while(it.hasNext())
			{ it.next();
			  String pattern=it.getText("match", true);
			  String accessor=it.getText("accessor",true);
			  cba.addBinding(pattern, accessor);
			}
			DependencyMeta dm = new DependencyMeta(aFrom,32);
			IURRepresentation result = new MonoRepresentationImpl(dm, cba);
			return result;
		}
		catch (XPathLocationException e)
		{	NetKernelException nke = new NetKernelException("Failure in ConfigToRDBMSConnection");
			nke.addCause(e);
			throw nke;
		}
	}
}