/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XmlObject2SAX.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2004/07/23 13:55:11 $
 *****************************************************************************/
package org.ten60.netkernel.xml.transrepresentation;

import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.transrepresentation.SimpleTransreptorImpl;
import org.ten60.netkernel.layer1.representation.MultiRepresentationImpl;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.NetKernelException;

import org.xml.sax.*;
import java.io.*;
import java.util.*;
import org.apache.xmlbeans.*;

/**
 * Convert an XMLObject into a SAX stream
 * @author  tab
 */
public class XmlObject2SAX extends SimpleTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectXmlObject.class) && ( aTo.isAssignableFrom(IAspectSAX.class)) );
	}
	
	public IURRepresentation transrepresent(IURRepresentation aFrom) throws NetKernelException
	{	try
		{	IAspectXmlObject aspect = (IAspectXmlObject)aFrom.getAspect(IAspectXmlObject.class);
			XmlObject xo=aspect.getImmutableXmlObject();
			IURAspect sax = new XmlObjectSAXAspect(xo);
			DependencyMeta meta = new DependencyMeta(aFrom, 2, 8);
			MultiRepresentationImpl mri=new MultiRepresentationImpl(meta, 2);
			mri.addAspectsOf(aFrom);
			mri.addAspect(sax);
			return mri;
		} catch (Exception e)
		{	NetKernelException e2 = new NetKernelException("Unhandled Exception in XmlObject2SAX");
			e2.addCause(e);
			throw e2;
		}
	}
}