/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.temptable.PersistentTableStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;

public class PersistentTableMutationStrategy
extends PersistentTableStrategy
implements SqmMultiTableMutationStrategy {
    public PersistentTableMutationStrategy(TemporaryTable idTable, SessionFactoryImplementor sessionFactory) {
        super(idTable, sessionFactory);
    }

    @Override
    public int executeUpdate(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new TableBasedUpdateHandler(sqmUpdate, domainParameterXref, this.getTemporaryTable(), this.getSessionFactory().getJdbcServices().getDialect().getTemporaryTableAfterUseAction(), session -> session.getSessionIdentifier().toString(), this.getSessionFactory()).execute(context);
    }

    @Override
    public int executeDelete(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        return new TableBasedDeleteHandler(sqmDelete, domainParameterXref, this.getTemporaryTable(), this.getSessionFactory().getJdbcServices().getDialect().getTemporaryTableAfterUseAction(), session -> session.getSessionIdentifier().toString(), this.getSessionFactory()).execute(context);
    }
}

