/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.applib.services.commanddto;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.apache.causeway.applib.annotation.Editing;
import org.apache.causeway.applib.annotation.LabelPosition;
import org.apache.causeway.applib.annotation.Property;
import org.apache.causeway.applib.annotation.PropertyLayout;
import org.apache.causeway.applib.annotation.ValueSemantics;

/**
 * Objects implementing this interface will be processed automatically by
 * {@link org.apache.causeway.applib.services.commanddto.conmap.ContentMappingServiceForCommandDto}.
 * @since 2.0 {@index}
 */
public interface HasCommandDto {

    @Property(
            editing = Editing.DISABLED
    )
    @PropertyLayout(
            multiLine = 15,
            labelPosition = LabelPosition.NONE
    )
    @ValueSemantics(provider = "pretty-render")
    @Target({ ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.ANNOTATION_TYPE })
    @Retention(RetentionPolicy.RUNTIME)
    @interface CommandDtoAnnot {
        boolean NULLABLE = false;
        String ALLOWS_NULL = "false";
    }

    @CommandDtoAnnot
    org.apache.causeway.schema.cmd.v2.CommandDto getCommandDto();
}
