/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.set.PredicatedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SetUtilsTest {
    private Set<Integer> setA;
    private Set<Integer> setB;

    @BeforeEach
    public void setUp() {
        this.setA = new HashSet<Integer>();
        this.setA.add(1);
        this.setA.add(2);
        this.setA.add(3);
        this.setA.add(4);
        this.setA.add(5);
        this.setB = new HashSet<Integer>();
        this.setB.add(3);
        this.setB.add(4);
        this.setB.add(5);
        this.setB.add(6);
        this.setB.add(7);
    }

    @Test
    public void testDifference() {
        SetUtils.SetView set = SetUtils.difference(this.setA, this.setB);
        Assertions.assertEquals((int)2, (int)set.size());
        Assertions.assertTrue((boolean)set.contains((Object)1));
        Assertions.assertTrue((boolean)set.contains((Object)2));
        for (Integer i : this.setB) {
            Assertions.assertFalse((boolean)set.contains((Object)i));
        }
        SetUtils.SetView set2 = SetUtils.difference(this.setA, (Set)SetUtils.emptySet());
        Assertions.assertEquals(this.setA, (Object)set2);
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.difference(this.setA, null));
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.difference(null, this.setA));
    }

    @Test
    public void testDisjunction() {
        SetUtils.SetView set = SetUtils.disjunction(this.setA, this.setB);
        Assertions.assertEquals((int)4, (int)set.size());
        Assertions.assertTrue((boolean)set.contains((Object)1));
        Assertions.assertTrue((boolean)set.contains((Object)2));
        Assertions.assertTrue((boolean)set.contains((Object)6));
        Assertions.assertTrue((boolean)set.contains((Object)7));
        Assertions.assertFalse((boolean)set.contains((Object)3));
        Assertions.assertFalse((boolean)set.contains((Object)4));
        Assertions.assertFalse((boolean)set.contains((Object)5));
        SetUtils.SetView set2 = SetUtils.disjunction(this.setA, (Set)SetUtils.emptySet());
        Assertions.assertEquals(this.setA, (Object)set2);
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.disjunction(this.setA, null));
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.disjunction(null, this.setA));
    }

    @Test
    public void testEmptyIfNull() {
        Assertions.assertTrue((boolean)SetUtils.emptyIfNull(null).isEmpty());
        HashSet set = new HashSet();
        Assertions.assertSame(set, (Object)SetUtils.emptyIfNull(set));
    }

    @Test
    public void testEquals() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        Assertions.assertEquals(a, b);
        Assertions.assertTrue((boolean)SetUtils.isEqualSet(a, b));
        a.clear();
        Assertions.assertFalse((boolean)SetUtils.isEqualSet(a, b));
        Assertions.assertFalse((boolean)SetUtils.isEqualSet(a, null));
        Assertions.assertFalse((boolean)SetUtils.isEqualSet(null, b));
        Assertions.assertTrue((boolean)SetUtils.isEqualSet(null, null));
    }

    @Test
    public void testHashCode() {
        List<String> data = Arrays.asList("a", "b", "c");
        HashSet<String> a = new HashSet<String>(data);
        HashSet<String> b = new HashSet<String>(data);
        Assertions.assertEquals((int)a.hashCode(), (int)b.hashCode());
        Assertions.assertEquals((int)a.hashCode(), (int)SetUtils.hashCodeForSet(a));
        Assertions.assertEquals((int)b.hashCode(), (int)SetUtils.hashCodeForSet(b));
        Assertions.assertEquals((int)SetUtils.hashCodeForSet(a), (int)SetUtils.hashCodeForSet(b));
        a.clear();
        Assertions.assertNotEquals((int)SetUtils.hashCodeForSet(a), (int)SetUtils.hashCodeForSet(b));
        Assertions.assertEquals((int)0, (int)SetUtils.hashCodeForSet(null));
    }

    @Test
    public void testHashSet() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Object[0]);
        Assertions.assertTrue((boolean)set1.isEmpty(), (String)"set is empty");
        HashSet set2 = SetUtils.hashSet((Object[])new Integer[]{1, 2, 2, 3});
        Assertions.assertEquals((int)3, (int)set2.size(), (String)"set has 3 elements");
        Assertions.assertTrue((boolean)set2.contains(1), (String)"set contains 1");
        Assertions.assertTrue((boolean)set2.contains(2), (String)"set contains 2");
        Assertions.assertTrue((boolean)set2.contains(3), (String)"set contains 3");
        HashSet set3 = SetUtils.hashSet((Object[])new String[]{"1", "2", "2", "3"});
        Assertions.assertEquals((int)3, (int)set3.size(), (String)"set has 3 elements");
        Assertions.assertTrue((boolean)set3.contains("1"), (String)"set contains 1");
        Assertions.assertTrue((boolean)set3.contains("2"), (String)"set contains 2");
        Assertions.assertTrue((boolean)set3.contains("3"), (String)"set contains 3");
        HashSet set4 = SetUtils.hashSet((Object[])new Object[]{null, null});
        Assertions.assertEquals((int)1, (int)set4.size(), (String)"set has 1 element");
        Assertions.assertTrue((boolean)set4.contains(null), (String)"set contains null");
        HashSet set5 = SetUtils.hashSet((Object[])null);
        Assertions.assertNull((Object)set5, (String)"set is null");
    }

    @Test
    public void testIntersection() {
        SetUtils.SetView set = SetUtils.intersection(this.setA, this.setB);
        Assertions.assertEquals((int)3, (int)set.size());
        Assertions.assertTrue((boolean)set.contains((Object)3));
        Assertions.assertTrue((boolean)set.contains((Object)4));
        Assertions.assertTrue((boolean)set.contains((Object)5));
        Assertions.assertFalse((boolean)set.contains((Object)1));
        Assertions.assertFalse((boolean)set.contains((Object)2));
        Assertions.assertFalse((boolean)set.contains((Object)6));
        Assertions.assertFalse((boolean)set.contains((Object)7));
        SetUtils.SetView set2 = SetUtils.intersection(this.setA, (Set)SetUtils.emptySet());
        Assertions.assertEquals((Object)SetUtils.emptySet(), (Object)set2);
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.intersection(this.setA, null));
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.intersection(null, this.setA));
    }

    @Test
    public void testNewIdentityHashSet() {
        Set set = SetUtils.newIdentityHashSet();
        String a = new String("a");
        set.add(a);
        set.add(new String("b"));
        set.add(a);
        Assertions.assertEquals((int)2, (int)set.size());
        set.add(new String("a"));
        Assertions.assertEquals((int)3, (int)set.size());
        set.remove(a);
        Assertions.assertEquals((int)2, (int)set.size());
    }

    @Test
    public void testpredicatedSet() {
        Predicate predicate = String.class::isInstance;
        Set set = SetUtils.predicatedSet(new HashSet(), (Predicate)predicate);
        Assertions.assertInstanceOf(PredicatedSet.class, (Object)set, (String)"returned object should be a PredicatedSet");
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.predicatedSet(new HashSet(), null), (String)"Expecting NullPointerException for null predicate.");
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.predicatedSet(null, (Predicate)predicate), (String)"Expecting NullPointerException for null set.");
    }

    @Test
    public void testUnion() {
        SetUtils.SetView set = SetUtils.union(this.setA, this.setB);
        Assertions.assertEquals((int)7, (int)set.size());
        Assertions.assertTrue((boolean)set.containsAll(this.setA));
        Assertions.assertTrue((boolean)set.containsAll(this.setB));
        SetUtils.SetView set2 = SetUtils.union(this.setA, (Set)SetUtils.emptySet());
        Assertions.assertEquals(this.setA, (Object)set2);
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.union(this.setA, null));
        Assertions.assertThrows(NullPointerException.class, () -> SetUtils.union(null, this.setA));
    }

    @Test
    public void testUnmodifiableSet() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Object[0]);
        Assertions.assertTrue((boolean)set1.isEmpty(), (String)"set is empty");
        Set set2 = SetUtils.unmodifiableSet((Object[])new Integer[]{1, 2, 2, 3});
        Assertions.assertEquals((int)3, (int)set2.size(), (String)"set has 3 elements");
        Assertions.assertTrue((boolean)set2.contains(1), (String)"set contains 1");
        Assertions.assertTrue((boolean)set2.contains(2), (String)"set contains 2");
        Assertions.assertTrue((boolean)set2.contains(3), (String)"set contains 3");
        Set set3 = SetUtils.unmodifiableSet((Object[])new String[]{"1", "2", "2", "3"});
        Assertions.assertEquals((int)3, (int)set3.size(), (String)"set has 3 elements");
        Assertions.assertTrue((boolean)set3.contains("1"), (String)"set contains 1");
        Assertions.assertTrue((boolean)set3.contains("2"), (String)"set contains 2");
        Assertions.assertTrue((boolean)set3.contains("3"), (String)"set contains 3");
        Set set4 = SetUtils.unmodifiableSet((Object[])new Object[]{null, null});
        Assertions.assertEquals((int)1, (int)set4.size(), (String)"set has 1 element");
        Assertions.assertTrue((boolean)set4.contains(null), (String)"set contains null");
        Set set5 = SetUtils.unmodifiableSet((Object[])null);
        Assertions.assertNull((Object)set5, (String)"set is null");
    }

    @Test
    public void testUnmodifiableSetWrap() {
        Set set1 = SetUtils.unmodifiableSet((Object[])new Integer[]{1, 2, 2, 3});
        Set set2 = SetUtils.unmodifiableSet((Set)set1);
        Assertions.assertSame((Object)set1, (Object)set2);
    }
}

