/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax;

import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail2.javax.AbstractEmailTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class InvalidInternetAddressTest
extends AbstractEmailTest {
    private static final String VALID_QUOTED_EMAIL = "\"John O'Groats\"@domain.com";
    private static final String[] ARR_INVALID_EMAILS = new String[]{"local name@domain.com", "local(name@domain.com", "local)name@domain.com", "local<name@domain.com", "local>name@domain.com", "local,name@domain.com", "local;name@domain.com", "local:name@domain.com", "local[name@domain.com", "local]name@domain.com", "local\tname@domain.com", "local\nname@domain.com", "local\rname@domain.com", "local.name@domain com", "local.name@domain(com", "local.name@domain)com", "local.name@domain<com", "local.name@domain>com", "local.name@domain,com", "local.name@domain;com", "local.name@domain:com", "local.name@domain]com", "local.name@domain\\com", "local.name@domain\tcom", "local.name@domain\ncom", "local.name@domain\rcom", "local.name@", "@domain.com"};

    @Test
    public void testStrictConstructor() throws Exception {
        IntStream.range(0, ARR_INVALID_EMAILS.length).forEach(i -> Assertions.assertThrows(Exception.class, () -> new InternetAddress(ARR_INVALID_EMAILS[i]), () -> "Strict " + i + " passed: " + ARR_INVALID_EMAILS[i]));
        Assertions.assertDoesNotThrow(() -> new InternetAddress(VALID_QUOTED_EMAIL), () -> "Valid Quoted Email failed: \"John O'Groats\"@domain.com");
    }

    @Test
    public void testValidateMethod() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            InternetAddress address = new InternetAddress(ARR_INVALID_EMAILS[i], "Joe");
            boolean quoted = ARR_INVALID_EMAILS[i].contains("\"");
            int atIndex = ARR_INVALID_EMAILS[i].indexOf("@");
            boolean domainBracket = atIndex >= 0 && ARR_INVALID_EMAILS[i].indexOf("[", atIndex) >= 0;
            try {
                address.validate();
                if (quoted || domainBracket) continue;
                Assertions.fail((String)("Validate " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (Exception ex) {
                if (!quoted && !domainBracket) continue;
                Assertions.fail((String)("Validate " + i + " failed: " + ARR_INVALID_EMAILS[i] + " - " + ex.getMessage()));
            }
        }
        Assertions.assertDoesNotThrow(() -> new InternetAddress(VALID_QUOTED_EMAIL, "Joe").validate(), () -> "Valid Quoted Email failed: \"John O'Groats\"@domain.com");
    }

    @Test
    public void testValidateMethodCharset() throws Exception {
        for (int i = 0; i < ARR_INVALID_EMAILS.length; ++i) {
            InternetAddress address = new InternetAddress(ARR_INVALID_EMAILS[i], "Joe", StandardCharsets.UTF_8.name());
            boolean quoted = ARR_INVALID_EMAILS[i].contains("\"");
            int atIndex = ARR_INVALID_EMAILS[i].indexOf("@");
            boolean domainBracket = atIndex >= 0 && ARR_INVALID_EMAILS[i].indexOf("[", atIndex) >= 0;
            try {
                address.validate();
                if (quoted || domainBracket) continue;
                Assertions.fail((String)("Validate " + i + " passed: " + ARR_INVALID_EMAILS[i]));
                continue;
            }
            catch (Exception ex) {
                if (!quoted && !domainBracket) continue;
                Assertions.fail((String)("Validate " + i + " failed: " + ARR_INVALID_EMAILS[i] + " - " + ex.getMessage()));
            }
        }
        Assertions.assertDoesNotThrow(() -> new InternetAddress(VALID_QUOTED_EMAIL, "Joe", StandardCharsets.UTF_8.name()).validate(), () -> "Valid Quoted Email failed: \"John O'Groats\"@domain.com");
    }
}

