/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCieLab;
import org.apache.commons.imaging.color.ColorCieLch;
import org.apache.commons.imaging.color.ColorCieLuv;
import org.apache.commons.imaging.color.ColorCmy;
import org.apache.commons.imaging.color.ColorCmyk;
import org.apache.commons.imaging.color.ColorConversions;
import org.apache.commons.imaging.color.ColorDin99Lab;
import org.apache.commons.imaging.color.ColorHsl;
import org.apache.commons.imaging.color.ColorHsv;
import org.apache.commons.imaging.color.ColorHunterLab;
import org.apache.commons.imaging.color.ColorXyz;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ColorConversionsTest {
    private static final int[] SAMPLE_RGBS = new int[]{-1, -16777216, -65536, -16711936, -16776961, -65281, -983296, -16711681, 0, -8421505};

    @Test
    public void testRgbToCmyk() {
        for (int rgb : SAMPLE_RGBS) {
            ColorCmy cmy = ColorConversions.convertRgbToCmy((int)rgb);
            ColorCmyk cmyk = ColorConversions.convertCmyToCmyk((ColorCmy)cmy);
            ColorCmy cmykCmy = ColorConversions.convertCmykToCmy((ColorCmyk)cmyk);
            int cmykCmyRgb = ColorConversions.convertCmyToRgb((ColorCmy)cmykCmy);
            Debug.debug((String)("cmy: " + cmy));
            Debug.debug((String)("cmyk: " + cmyk));
            Debug.debug((String)("cmykCmy: " + cmykCmy));
            Debug.debug((String)("cmykCmyRgb: " + cmykCmyRgb + " (" + Integer.toHexString(cmykCmyRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & cmykCmyRgb));
        }
    }

    @Test
    public void testRgbToDin99b() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRgbToXyz((int)rgb);
            ColorCieLab cielab = ColorConversions.convertXyzToCieLab((ColorXyz)xyz);
            ColorDin99Lab din99b = ColorConversions.convertCieLabToDin99bLab((ColorCieLab)cielab);
            ColorCieLab din99Cielab = ColorConversions.convertDin99bLabToCieLab((ColorDin99Lab)din99b);
            ColorXyz din99CielabXyz = ColorConversions.convertCieLabToXyz((ColorCieLab)din99Cielab);
            int din99CielabXyzRgb = ColorConversions.convertXyzToRgb((ColorXyz)din99CielabXyz);
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & din99CielabXyzRgb));
        }
    }

    @Test
    public void testRgbToDin99o() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRgbToXyz((int)rgb);
            ColorCieLab cielab = ColorConversions.convertXyzToCieLab((ColorXyz)xyz);
            ColorDin99Lab din99o = ColorConversions.convertCieLabToDin99oLab((ColorCieLab)cielab);
            ColorCieLab din99Cielab = ColorConversions.convertDin99oLabToCieLab((ColorDin99Lab)din99o);
            ColorXyz din99CielabXyz = ColorConversions.convertCieLabToXyz((ColorCieLab)din99Cielab);
            int din99CielabXyzRgb = ColorConversions.convertXyzToRgb((ColorXyz)din99CielabXyz);
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & din99CielabXyzRgb));
        }
    }

    @Test
    public void testRgbToHsl() {
        for (int rgb : SAMPLE_RGBS) {
            ColorHsl hsl = ColorConversions.convertRgbToHsl((int)rgb);
            int hslRgb = ColorConversions.convertHslToRgb((ColorHsl)hsl);
            Debug.debug((String)("hsl: " + hsl));
            Debug.debug((String)("hslRgb: " + hslRgb + " (" + Integer.toHexString(hslRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hslRgb));
        }
    }

    @Test
    public void testRgbToHsv() {
        for (int rgb : SAMPLE_RGBS) {
            ColorHsv hsv = ColorConversions.convertRgbToHsv((int)rgb);
            int hsvRgb = ColorConversions.convertHsvToRgb((ColorHsv)hsv);
            Debug.debug((String)("hsv: " + hsv));
            Debug.debug((String)("hsvRgb: " + hsvRgb + " (" + Integer.toHexString(hsvRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hsvRgb));
        }
    }

    @Test
    public void testXyz() {
        for (int rgb : SAMPLE_RGBS) {
            ColorXyz xyz = ColorConversions.convertRgbToXyz((int)rgb);
            int xyzRgb = ColorConversions.convertXyzToRgb((ColorXyz)xyz);
            Debug.debug();
            Debug.debug((String)("rgb: " + rgb + " (" + Integer.toHexString(rgb) + ")"));
            Debug.debug((String)("xyz: " + xyz));
            Debug.debug((String)("xyzRgb: " + xyzRgb + " (" + Integer.toHexString(xyzRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & xyzRgb), (String)("rgb " + Integer.toHexString(rgb) + ", " + xyz));
            ColorCieLab cielab = ColorConversions.convertXyzToCieLab((ColorXyz)xyz);
            ColorXyz cielabXyz = ColorConversions.convertCieLabToXyz((ColorCieLab)cielab);
            int cielabXyzRgb = ColorConversions.convertXyzToRgb((ColorXyz)cielabXyz);
            Debug.debug((String)("cielab: " + cielab));
            Debug.debug((String)("cielabXyz: " + cielabXyz));
            Debug.debug((String)("cielabXyzRgb: " + cielabXyzRgb + " (" + Integer.toHexString(cielabXyzRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & cielabXyzRgb));
            ColorHunterLab hunterlab = ColorConversions.convertXyzToHunterLab((ColorXyz)xyz);
            ColorXyz hunterlabXyz = ColorConversions.convertHunterLabToXyz((ColorHunterLab)hunterlab);
            int hunterlabXyzRgb = ColorConversions.convertXyzToRgb((ColorXyz)hunterlabXyz);
            Debug.debug((String)("hunterlab: " + hunterlab));
            Debug.debug((String)("hunterlabXyz: " + hunterlabXyz));
            Debug.debug((String)("hunterlabXyzRgb: " + hunterlabXyzRgb + " (" + Integer.toHexString(hunterlabXyzRgb) + ")"));
            Assertions.assertEquals((Object)Integer.toHexString(0xFFFFFF & rgb), (Object)Integer.toHexString(0xFFFFFF & hunterlabXyzRgb));
            ColorCieLch cielch = ColorConversions.convertCieLabToCieLch((ColorCieLab)cielab);
            ColorCieLab cielchCielab = ColorConversions.convertCieLchToCieLab((ColorCieLch)cielch);
            Debug.debug((String)"cielch", (Object)cielch);
            Debug.debug((String)"cielchCielab", (Object)cielchCielab);
            ColorCieLuv cieluv = ColorConversions.convertXyzToCieLuv((ColorXyz)xyz);
            ColorXyz cieluvXyz = ColorConversions.convertCieLuvToXyz((ColorCieLuv)cieluv);
            Debug.debug((String)"cieluv", (Object)cieluv);
            Debug.debug((String)"cieluvXyz", (Object)cieluvXyz);
        }
    }
}

