/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.gif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;

public abstract class AbstractGifTest
extends AbstractImagingTest {
    private static final String ANIMATED_FOLDER_NAME = "animated";
    private static final String SINGLE_IMAGE_FOLDER_NAME = "single";
    private static final AbstractImagingTest.ImageFilter IMAGE_FILTER = AbstractGifTest::isGif;
    private static final AbstractImagingTest.ImageFilter ANIMATED_IMAGE_FILTER = file -> AbstractGifTest.isGif(file) && AbstractGifTest.isAnimated(file);
    private static final AbstractImagingTest.ImageFilter SINGLE_IMAGE_FILTER = file -> AbstractGifTest.isGif(file) && AbstractGifTest.isSingleImage(file);

    protected static List<File> getAnimatedGifImages() throws IOException, ImagingException {
        return AbstractGifTest.getTestImages(ANIMATED_IMAGE_FILTER);
    }

    protected static List<File> getGifImages() throws IOException, ImagingException {
        return AbstractGifTest.getTestImages(IMAGE_FILTER);
    }

    protected static List<File> getGifImagesWithSingleImage() throws IOException, ImagingException {
        return AbstractGifTest.getTestImages(SINGLE_IMAGE_FILTER);
    }

    private static boolean isAnimated(File file) {
        File index = file.getParentFile();
        File type = index.getParentFile();
        return type.getName().equals(ANIMATED_FOLDER_NAME);
    }

    private static boolean isGif(File file) throws IOException {
        ImageFormat format = Imaging.guessFormat((File)file);
        return format == ImageFormats.GIF;
    }

    private static boolean isSingleImage(File file) {
        File index = file.getParentFile();
        File type = index.getParentFile();
        return type.getName().equals(SINGLE_IMAGE_FOLDER_NAME);
    }
}

