/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputDirectory;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputField;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.TestSkippedException;

public class ExifRewriterRoundtripTest
extends AbstractExifTest {
    private final SecureRandom random = new SecureRandom();
    private File duplicateFile;

    public static Stream<File> data() throws Exception {
        return ExifRewriterRoundtripTest.getImagesWithExifData().stream();
    }

    private void assertTiffEquals(TiffOutputSet sourceTiffOutputSet, TiffOutputSet duplicateTiffOutputSet) {
        List sourceDirectories = sourceTiffOutputSet.getDirectories();
        List duplicatedDirectories = duplicateTiffOutputSet.getDirectories();
        Assertions.assertEquals((int)sourceDirectories.size(), (int)duplicatedDirectories.size(), (String)"The TiffOutputSets have different numbers of directories.");
        for (int i = 0; i < sourceDirectories.size(); ++i) {
            boolean fieldCountMatches;
            TiffOutputDirectory sourceDirectory = (TiffOutputDirectory)sourceDirectories.get(i);
            TiffOutputDirectory duplicateDirectory = (TiffOutputDirectory)duplicatedDirectories.get(i);
            Assertions.assertEquals((int)sourceDirectory.getType(), (int)duplicateDirectory.getType(), (String)"Directory type mismatch.");
            List sourceFields = sourceDirectory.getFields();
            List duplicateFields = duplicateDirectory.getFields();
            boolean bl = fieldCountMatches = sourceFields.size() == duplicateFields.size();
            if (!fieldCountMatches) {
                ArrayList<Integer> sourceTags = new ArrayList<Integer>();
                ArrayList<Integer> duplicatedTags = new ArrayList<Integer>();
                for (TiffOutputField field : sourceFields) {
                    sourceTags.add(field.tag);
                }
                for (TiffOutputField field : duplicateFields) {
                    duplicatedTags.add(field.tag);
                }
                ArrayList missingTags = new ArrayList(sourceTags);
                missingTags.removeAll(duplicatedTags);
                missingTags.remove((Object)ExifTagConstants.EXIF_TAG_EXIF_OFFSET.tag);
                missingTags.remove((Object)ExifTagConstants.EXIF_TAG_GPSINFO.tag);
                missingTags.remove((Object)ExifTagConstants.EXIF_TAG_INTEROP_OFFSET.tag);
                missingTags.remove((Object)TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT.tag);
                Assertions.assertTrue((boolean)missingTags.isEmpty(), (String)("Missing tags: " + missingTags));
            }
            for (TiffOutputField sourceField : sourceFields) {
                boolean isOffsetField;
                boolean bl2 = isOffsetField = sourceField.tag == ExifTagConstants.EXIF_TAG_EXIF_OFFSET.tag || sourceField.tag == ExifTagConstants.EXIF_TAG_GPSINFO.tag || sourceField.tag == ExifTagConstants.EXIF_TAG_INTEROP_OFFSET.tag || sourceField.tag == TiffTagConstants.TIFF_TAG_JPEG_INTERCHANGE_FORMAT.tag;
                if (isOffsetField) continue;
                TiffOutputField duplicateField = duplicateDirectory.findField(sourceField.tag);
                Assertions.assertNotNull((Object)duplicateField, (String)("Field is missing: " + sourceField.tagInfo));
                Assertions.assertEquals((int)sourceField.tag, (int)duplicateField.tag, (String)"TiffOutputField tag mismatch.");
                Assertions.assertEquals((Object)sourceField.abstractFieldType, (Object)duplicateField.abstractFieldType, (String)"TiffOutputField fieldType mismatch.");
                Assertions.assertEquals((int)sourceField.count, (int)duplicateField.count, (String)"TiffOutputField count mismatch.");
                Assertions.assertArrayEquals((byte[])sourceField.getData(), (byte[])duplicateField.getData(), (String)("Bytes are different for field: " + sourceField));
            }
        }
    }

    private void copyToDuplicateFile(File sourceFile, TiffOutputSet duplicateTiffOutputSet) throws IOException {
        ExifRewriter exifRewriter = new ExifRewriter();
        this.duplicateFile = this.createTempFile();
        try (BufferedOutputStream duplicateOutputStream = new BufferedOutputStream(Files.newOutputStream(this.duplicateFile.toPath(), new OpenOption[0]));){
            exifRewriter.updateExifMetadataLossless(sourceFile, (OutputStream)duplicateOutputStream, duplicateTiffOutputSet);
        }
    }

    private File createTempFile() {
        String tempDir = FileUtils.getTempDirectoryPath();
        String tempFileName = this.getClass().getName() + "-" + this.random.nextLong() + ".tmp";
        return new File(tempDir, tempFileName);
    }

    private TiffOutputSet duplicateTiffOutputSet(TiffOutputSet sourceTiffOutputSet) throws ImagingException {
        TiffOutputSet duplicateTiffOutputSet = new TiffOutputSet(sourceTiffOutputSet.byteOrder);
        for (TiffOutputDirectory tiffOutputDirectory : sourceTiffOutputSet) {
            duplicateTiffOutputSet.addDirectory(tiffOutputDirectory);
        }
        return duplicateTiffOutputSet;
    }

    private JpegImageMetadata getJpegImageMetadata(File sourceFile) throws IOException {
        JpegImageMetadata jpegImageMetadata = (JpegImageMetadata)Imaging.getMetadata((File)sourceFile);
        if (jpegImageMetadata == null) {
            throw new TestSkippedException();
        }
        return jpegImageMetadata;
    }

    private TiffImageMetadata getTiffImageMetadata(JpegImageMetadata sourceJpegImageMetadata) {
        TiffImageMetadata tiffImageMetadata = sourceJpegImageMetadata.getExif();
        if (tiffImageMetadata == null) {
            throw new TestSkippedException();
        }
        return tiffImageMetadata;
    }

    private TiffOutputSet getTiffOutputSet(TiffImageMetadata sourceTiffImageMetadata) throws ImagingException {
        TiffOutputSet tiffOutputSet = sourceTiffImageMetadata.getOutputSet();
        if (tiffOutputSet == null) {
            throw new TestSkippedException();
        }
        return tiffOutputSet;
    }

    @AfterEach
    void tearDown() {
        if (this.duplicateFile != null && this.duplicateFile.exists()) {
            this.duplicateFile.delete();
            this.duplicateFile.deleteOnExit();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void updateExifMetadataLossless_copyWithoutChanges_TiffOutputSetsAreIdentical(File sourceFile) throws Exception {
        JpegImageMetadata sourceJpegImageMetadata = this.getJpegImageMetadata(sourceFile);
        TiffImageMetadata sourceTiffImageMetadata = this.getTiffImageMetadata(sourceJpegImageMetadata);
        TiffOutputSet sourceTiffOutputSet = this.getTiffOutputSet(sourceTiffImageMetadata);
        TiffOutputSet duplicateTiffOutputSet = this.duplicateTiffOutputSet(sourceTiffOutputSet);
        this.assertTiffEquals(sourceTiffOutputSet, duplicateTiffOutputSet);
        this.copyToDuplicateFile(sourceFile, duplicateTiffOutputSet);
        JpegImageMetadata duplicateJpegImageMetadata = this.getJpegImageMetadata(this.duplicateFile);
        TiffImageMetadata duplicateTiffImageMetadata = this.getTiffImageMetadata(duplicateJpegImageMetadata);
        duplicateTiffOutputSet = duplicateTiffImageMetadata.getOutputSet();
        this.assertTiffEquals(sourceTiffOutputSet, duplicateTiffOutputSet);
    }
}

