/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorCieLch {
    public static final ColorCieLch BLACK = new ColorCieLch(0.0, 0.0, 0.0);
    public static final ColorCieLch WHITE = new ColorCieLch(100.0, 0.0, 297.0);
    public static final ColorCieLch RED = new ColorCieLch(53.0, 80.0, 67.0);
    public static final ColorCieLch GREEN = new ColorCieLch(88.0, -86.0, 83.0);
    public static final ColorCieLch BLUE = new ColorCieLch(32.0, 79.0, -108.0);
    public final double l;
    public final double c;
    public final double h;

    public ColorCieLch(double l, double c, double h) {
        this.l = l;
        this.c = c;
        this.h = h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorCieLch that = (ColorCieLch)o;
        if (Double.compare(that.c, this.c) != 0) {
            return false;
        }
        if (Double.compare(that.h, this.h) != 0) {
            return false;
        }
        return Double.compare(that.l, this.l) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.l);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.h);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return "{L: " + this.l + ", C: " + this.c + ", h: " + this.h + "}";
    }
}

