/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.clustering;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.legacy.ml.clustering.Clusterable;
import org.apache.commons.math4.legacy.ml.clustering.DoublePoint;

public class Cluster<T extends Clusterable> {
    private final List<T> points = new ArrayList<T>();

    public void addPoint(T point) {
        this.points.add(point);
    }

    public List<T> getPoints() {
        return this.points;
    }

    public Clusterable centroid() {
        if (this.points.isEmpty()) {
            return null;
        }
        int dimension = ((Clusterable)this.points.get(0)).getPoint().length;
        double[] centroid = new double[dimension];
        for (Clusterable p : this.points) {
            double[] point = p.getPoint();
            for (int i = 0; i < centroid.length; ++i) {
                int n = i;
                centroid[n] = centroid[n] + point[i];
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (double)this.points.size();
        }
        return new DoublePoint(centroid);
    }
}

