/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.interval;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.ConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.IntervalUtils;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class NormalApproximationInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double mean = (double)numberOfSuccesses / (double)numberOfTrials;
        double alpha = (1.0 - confidenceLevel) / 2.0;
        NormalDistribution normalDistribution = NormalDistribution.of((double)0.0, (double)1.0);
        double difference = normalDistribution.inverseSurvivalProbability(alpha) * JdkMath.sqrt((double)(1.0 / (double)numberOfTrials * mean * (1.0 - mean)));
        return new ConfidenceInterval(mean - difference, mean + difference, confidenceLevel);
    }
}

