/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.UInt192;

public final class LongSumOfSquares
implements LongStatistic,
StatisticAccumulator<LongSumOfSquares> {
    private final UInt192 sumSq;

    private LongSumOfSquares() {
        this(UInt192.create());
    }

    private LongSumOfSquares(UInt192 sumSq) {
        this.sumSq = sumSq;
    }

    public static LongSumOfSquares create() {
        return new LongSumOfSquares();
    }

    public static LongSumOfSquares of(long ... values) {
        UInt192 ss = UInt192.create();
        for (long x : values) {
            ss.addSquare(x);
        }
        return new LongSumOfSquares(ss);
    }

    public static LongSumOfSquares ofRange(long[] values, int from, int to) {
        Statistics.checkFromToIndex(from, to, values.length);
        return LongSumOfSquares.createFromRange(values, from, to);
    }

    static LongSumOfSquares createFromRange(long[] values, int from, int to) {
        UInt192 ss = UInt192.create();
        for (int i = from; i < to; ++i) {
            ss.addSquare(values[i]);
        }
        return new LongSumOfSquares(ss);
    }

    UInt192 getSumOfSquares() {
        return this.sumSq;
    }

    @Override
    public void accept(long value) {
        this.sumSq.addSquare(value);
    }

    @Override
    public int getAsInt() {
        return this.sumSq.toIntExact();
    }

    @Override
    public long getAsLong() {
        return this.sumSq.toLongExact();
    }

    @Override
    public double getAsDouble() {
        return this.sumSq.toDouble();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.sumSq.toBigInteger();
    }

    @Override
    public LongSumOfSquares combine(LongSumOfSquares other) {
        this.sumSq.add(other.sumSq);
        return this;
    }
}

