/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTupleAvlCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final AvlTreeCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleAvlCursor(AvlTree<V> avlTree, K key) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyTupleAvlCursor {}", (Object)this);
        }
        this.key = key;
        this.wrapped = new AvlTreeCursor<V>(avlTree);
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed();
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.wrapped.before(value);
        this.clearValue();
    }

    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed();
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.wrapped.after(value);
        this.clearValue();
    }

    @Override
    public void before(Tuple<K, V> element) throws CursorException, LdapException {
        this.checkNotClosed();
        this.wrapped.before(element.getValue());
        this.clearValue();
    }

    @Override
    public void after(Tuple<K, V> element) throws LdapException, CursorException {
        this.checkNotClosed();
        this.wrapped.after(element.getValue());
        this.clearValue();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.wrapped.beforeFirst();
        this.clearValue();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.wrapped.afterLast();
        this.clearValue();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.wrapped.previous()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        if (this.wrapped.next()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public Tuple<K, V> get() throws CursorException {
        this.checkNotClosed();
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleAvlCursor {}", (Object)this);
        }
        super.close();
        if (this.wrapped != null) {
            this.wrapped.close();
        }
    }

    @Override
    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleAvlCursor {}", (Object)this);
        }
        super.close(cause);
        if (this.wrapped != null) {
            this.wrapped.close(cause);
        }
    }
}

