/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.dnd;

import java.util.Set;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.ui.dnd.ConnectionTransfer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DropConnectionListener
implements DropTargetListener {
    public void dragEnter(DropTargetEvent event) {
        if (!ConnectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.dragOver(event);
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        try {
            boolean isMoveConnectionFolderForbidden = false;
            if ((event.detail == 2 || event.detail == 0) && ConnectionTransfer.getInstance().isSupportedType(event.currentDataType) && event.item != null && event.item.getData() instanceof ConnectionFolder) {
                DropTarget dropTarget;
                ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
                ConnectionFolder overFolder = (ConnectionFolder)event.item.getData();
                Set allParentFolders = connectionFolderManager.getAllParentFolders(overFolder);
                if (event.widget instanceof DropTarget && (dropTarget = (DropTarget)event.widget).getControl() instanceof Tree) {
                    Tree tree = (Tree)dropTarget.getControl();
                    TreeItem[] treeItemArray = tree.getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ConnectionFolder folder;
                        TreeItem treeItem = treeItemArray[n2];
                        if (treeItem.getData() instanceof ConnectionFolder && allParentFolders.contains(folder = (ConnectionFolder)treeItem.getData())) {
                            isMoveConnectionFolderForbidden = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            if (!ConnectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                event.detail = 0;
            } else if (isMoveConnectionFolderForbidden) {
                event.detail = 0;
            } else if (event.detail == 4) {
                event.detail = 0;
            } else if (event.detail == 0) {
                event.detail = 16;
            }
        }
        catch (Exception e) {
            event.detail = 0;
            e.printStackTrace();
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        ConnectionManager connectionManager = ConnectionCorePlugin.getDefault().getConnectionManager();
        ConnectionFolderManager connectionFolderManager = ConnectionCorePlugin.getDefault().getConnectionFolderManager();
        try {
            if (ConnectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Object[] objects = (Object[])event.data;
                Object target = event.item == null ? connectionFolderManager.getRootConnectionFolder() : event.item.getData();
                Object targetFolder = null;
                if (target instanceof ConnectionFolder) {
                    targetFolder = target;
                } else if (target instanceof Connection) {
                    Connection connection = (Connection)target;
                    targetFolder = connectionFolderManager.getParentConnectionFolder(connection);
                }
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectionFolder parentConnectionFolder;
                    Object object = objectArray[n2];
                    if (object instanceof Connection) {
                        Connection connection = (Connection)object;
                        if (event.detail == 2) {
                            parentConnectionFolder = connectionFolderManager.getParentConnectionFolder(connection);
                            parentConnectionFolder.removeConnectionId(connection.getId());
                            targetFolder.addConnectionId(connection.getId());
                        } else if (event.detail == 1) {
                            Connection newConnection = (Connection)connection.clone();
                            connectionManager.addConnection(newConnection);
                            targetFolder.addConnectionId(newConnection.getId());
                        }
                    } else if (object instanceof ConnectionFolder) {
                        ConnectionFolder folder = (ConnectionFolder)object;
                        if (event.detail == 2) {
                            parentConnectionFolder = connectionFolderManager.getParentConnectionFolder(folder);
                            parentConnectionFolder.removeSubFolderId(folder.getId());
                            targetFolder.addSubFolderId(folder.getId());
                        } else if (event.detail == 1) {
                            ConnectionFolder newFolder = (ConnectionFolder)folder.clone();
                            connectionFolderManager.addConnectionFolder(newFolder);
                            targetFolder.addSubFolderId(newFolder.getId());
                        }
                    }
                    ++n2;
                }
            } else {
                event.detail = 0;
            }
        }
        catch (Exception e) {
            event.detail = 0;
            e.printStackTrace();
        }
    }
}

