/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.Collection;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClassTypeEnum;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.Messages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.SearchContinuation;
import org.apache.directory.studio.ldapbrowser.core.model.schema.ObjectClassIconPair;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BrowserLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    private BrowserPreferences preferences;

    public BrowserLabelProvider(BrowserPreferences preferences) {
        this.preferences = preferences;
    }

    public String getText(Object obj) {
        if (obj instanceof IEntry) {
            IEntry entry = (IEntry)obj;
            StringBuffer append = new StringBuffer();
            if (entry.isChildrenInitialized() && entry.getChildrenCount() > 0 || entry.getChildrenFilter() != null) {
                append.append(" (").append(entry.getChildrenCount());
                if (entry.hasMoreChildren()) {
                    append.append("+");
                }
                if (entry.getChildrenFilter() != null) {
                    append.append(", filtered");
                }
                append.append(")");
            }
            if (entry instanceof IRootDSE) {
                return "Root DSE" + append.toString();
            }
            if (entry instanceof IContinuation) {
                return String.valueOf(entry.getUrl().toString()) + append.toString();
            }
            if (entry instanceof BaseDNEntry) {
                return String.valueOf(entry.getDn().getName()) + append.toString();
            }
            if (entry.hasParententry()) {
                String label = "";
                if (this.preferences.getEntryLabel() == 0) {
                    label = entry.getDn().getName();
                } else if (this.preferences.getEntryLabel() == 1) {
                    label = entry.getRdn().getName();
                } else if (this.preferences.getEntryLabel() == 2) {
                    label = entry.getRdn().getName();
                }
                label = String.valueOf(label) + append.toString();
                if (this.preferences.isEntryAbbreviate() && label.length() > this.preferences.getEntryAbbreviateMaxLength()) {
                    label = Utils.shorten((String)label, (int)this.preferences.getEntryAbbreviateMaxLength());
                }
                return label;
            }
            return String.valueOf(entry.getDn().getName()) + append.toString();
        }
        if (obj instanceof SearchContinuation) {
            SearchContinuation sc = (SearchContinuation)obj;
            return sc.getUrl().toString();
        }
        if (obj instanceof BrowserEntryPage) {
            BrowserEntryPage container = (BrowserEntryPage)obj;
            return "[" + (container.getFirst() + 1) + "..." + (container.getLast() + 1) + "]";
        }
        if (obj instanceof BrowserSearchResultPage) {
            BrowserSearchResultPage container = (BrowserSearchResultPage)obj;
            return "[" + (container.getFirst() + 1) + "..." + (container.getLast() + 1) + "]";
        }
        if (obj instanceof ISearch) {
            ISearch search = (ISearch)obj;
            ISearchResult[] results = search.getSearchResults();
            SearchContinuation[] scs = search.getSearchContinuations();
            StringBuffer append = new StringBuffer(search.getName());
            if (results != null && scs != null) {
                append.append(" (").append(results.length + scs.length);
                if (search.isCountLimitExceeded()) {
                    append.append("+");
                }
                append.append(")");
            }
            return append.toString();
        }
        if (obj instanceof IBookmark) {
            IBookmark bookmark = (IBookmark)obj;
            return bookmark.getName();
        }
        if (obj instanceof ISearchResult) {
            ISearchResult sr = (ISearchResult)obj;
            if (sr.getEntry() instanceof IContinuation) {
                return sr.getEntry().getUrl().toString();
            }
            if (sr.getEntry().hasParententry() || sr.getEntry() instanceof IRootDSE) {
                String label = "";
                if (sr.getEntry() instanceof IRootDSE) {
                    label = "Root DSE";
                } else if (this.preferences.getSearchResultLabel() == 0) {
                    label = sr.getEntry().getDn().getName();
                } else if (this.preferences.getSearchResultLabel() == 1) {
                    label = sr.getEntry().getRdn().getName();
                } else if (this.preferences.getSearchResultLabel() == 2) {
                    label = sr.getEntry().getRdn().getName();
                }
                if (this.preferences.isSearchResultAbbreviate() && label.length() > this.preferences.getSearchResultAbbreviateMaxLength()) {
                    label = Utils.shorten((String)label, (int)this.preferences.getSearchResultAbbreviateMaxLength());
                }
                return label;
            }
            return sr.getEntry().getDn().getName();
        }
        if (obj instanceof StudioConnectionRunnableWithProgress) {
            StudioConnectionRunnableWithProgress runnable = (StudioConnectionRunnableWithProgress)obj;
            Object[] objectArray = runnable.getLockedObjects();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object lockedObject = objectArray[n2];
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (obj == search.getTopSearchRunnable()) {
                        return Messages.getString("BrowserLabelProvider.TopPage");
                    }
                    if (obj == search.getNextSearchRunnable()) {
                        return Messages.getString("BrowserLabelProvider.NextPage");
                    }
                } else if (lockedObject instanceof IEntry) {
                    IEntry entry = (IEntry)lockedObject;
                    if (obj == entry.getTopPageChildrenRunnable()) {
                        return Messages.getString("BrowserLabelProvider.TopPage");
                    }
                    if (obj == entry.getNextPageChildrenRunnable()) {
                        return Messages.getString("BrowserLabelProvider.NextPage");
                    }
                }
                ++n2;
            }
            return obj.toString();
        }
        if (obj instanceof BrowserCategory) {
            BrowserCategory category = (BrowserCategory)obj;
            return category.getTitle();
        }
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public Image getImage(Object obj) {
        if (obj instanceof IEntry) {
            IEntry entry = (IEntry)obj;
            if (entry instanceof IRootDSE) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/entry_root.gif");
            }
            if (entry instanceof DirectoryMetadataEntry && ((DirectoryMetadataEntry)entry).isSchemaEntry()) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/browser_schemabrowsereditor.gif");
            }
            if (entry.getDn().equals((Object)entry.getBrowserConnection().getSchema().getDn())) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/browser_schemabrowsereditor.gif");
            }
            return BrowserLabelProvider.getImageByObjectClass(entry);
        }
        if (obj instanceof BrowserEntryPage) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (obj instanceof BrowserSearchResultPage) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (obj instanceof IQuickSearch) {
            return BrowserCommonActivator.getDefault().getImage("resources/icons/quicksearch.gif");
        }
        if (obj instanceof ISearch) {
            ISearch search = (ISearch)obj;
            if (search instanceof IContinuation && ((IContinuation)search).getState() != IContinuation.State.RESOLVED) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/search_unperformed.gif");
            }
            if (search.getSearchResults() != null) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/search.gif");
            }
            return BrowserCommonActivator.getDefault().getImage("resources/icons/search_unperformed.gif");
        }
        if (obj instanceof IBookmark) {
            return BrowserCommonActivator.getDefault().getImage("resources/icons/bookmark.gif");
        }
        if (obj instanceof ISearchResult) {
            ISearchResult sr = (ISearchResult)obj;
            IEntry entry = sr.getEntry();
            return BrowserLabelProvider.getImageByObjectClass(entry);
        }
        if (obj instanceof StudioConnectionRunnableWithProgress) {
            StudioConnectionRunnableWithProgress runnable = (StudioConnectionRunnableWithProgress)obj;
            Object[] objectArray = runnable.getLockedObjects();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object lockedObject = objectArray[n2];
                if (lockedObject instanceof ISearch) {
                    ISearch search = (ISearch)lockedObject;
                    if (obj == search.getTopSearchRunnable()) {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/top.gif");
                    }
                    if (obj == search.getNextSearchRunnable()) {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/next.gif");
                    }
                } else if (lockedObject instanceof IEntry) {
                    IEntry entry = (IEntry)lockedObject;
                    if (obj == entry.getTopPageChildrenRunnable()) {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/top.gif");
                    }
                    if (obj == entry.getNextPageChildrenRunnable()) {
                        return BrowserCommonActivator.getDefault().getImage("resources/icons/next.gif");
                    }
                }
                ++n2;
            }
            return null;
        }
        if (obj instanceof BrowserCategory) {
            BrowserCategory category = (BrowserCategory)obj;
            if (category.getType() == 0) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/dit.gif");
            }
            if (category.getType() == 1) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/searches.gif");
            }
            if (category.getType() == 2) {
                return BrowserCommonActivator.getDefault().getImage("resources/icons/bookmarks.gif");
            }
            return null;
        }
        return null;
    }

    public static Image getImageByObjectClass(IEntry entry) {
        Schema schema = entry.getBrowserConnection().getSchema();
        Collection ocds = entry.getObjectClassDescriptions();
        if (ocds != null) {
            Collection numericOids = SchemaUtils.getNumericOids((Collection)ocds);
            ObjectClassIconPair[] objectClassIcons = BrowserCorePlugin.getDefault().getCorePreferences().getObjectClassIcons();
            int maxWeight = 0;
            ObjectClassIconPair maxObjectClassIconPair = null;
            ObjectClassIconPair[] objectClassIconPairArray = objectClassIcons;
            int n = objectClassIcons.length;
            int n2 = 0;
            while (n2 < n) {
                String[] ocNumericOids;
                ObjectClassIconPair objectClassIconPair = objectClassIconPairArray[n2];
                int weight = 0;
                String[] stringArray = ocNumericOids = objectClassIconPair.getOcNumericOids();
                int n3 = ocNumericOids.length;
                int n4 = 0;
                while (n4 < n3) {
                    String ocNumericOid = stringArray[n4];
                    if (numericOids.contains(ocNumericOid)) {
                        ObjectClass ocd = schema.getObjectClassDescription(ocNumericOid);
                        if (ocd.getType() == ObjectClassTypeEnum.STRUCTURAL) {
                            weight += 3;
                        } else if (ocd.getType() == ObjectClassTypeEnum.AUXILIARY) {
                            weight += 2;
                        }
                    }
                    ++n4;
                }
                if (weight > maxWeight) {
                    maxObjectClassIconPair = objectClassIconPair;
                }
                ++n2;
            }
            if (maxObjectClassIconPair != null) {
                return BrowserCommonActivator.getDefault().getImage(maxObjectClassIconPair.getIconPath());
            }
        }
        return BrowserCommonActivator.getDefault().getImage("resources/icons/entry_default.gif");
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

