/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.nio.charset.StandardCharsets;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;

public class StringValueEditorUtils {
    static String getDisplayValue(Object rawValue) {
        if (rawValue == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        return rawValue.toString();
    }

    static Object getRawValue(IValue value) {
        if (value == null) {
            return null;
        }
        if (value.isString()) {
            return value.getStringValue();
        }
        if (value.isBinary() && StringValueEditorUtils.isEditable(value.getBinaryValue())) {
            return value.getStringValue();
        }
        return null;
    }

    static Object getStringOrBinaryValue(Object rawValue) {
        if (rawValue instanceof String) {
            return rawValue;
        }
        return null;
    }

    static boolean isEditable(byte[] b) {
        if (b == null) {
            return false;
        }
        return !new String(b, StandardCharsets.UTF_8).contains("\ufffd");
    }
}

