/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Internal
final class QueryStringDecoder {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final int maxParams;
    private int pathEndIdx;
    private String path;
    private Map<String, List<String>> params;

    QueryStringDecoder(String uri) {
        this(uri, StandardCharsets.UTF_8);
    }

    QueryStringDecoder(String uri, boolean hasPath) {
        this(uri, StandardCharsets.UTF_8, hasPath);
    }

    QueryStringDecoder(String uri, Charset charset) {
        this(uri, charset, true);
    }

    QueryStringDecoder(String uri, Charset charset, boolean hasPath) {
        this(uri, charset, hasPath, 1024);
    }

    QueryStringDecoder(String uri, Charset charset, boolean hasPath, int maxParams) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.charset = Objects.requireNonNull(charset, "charset");
        this.maxParams = Objects.requireNonNull(Integer.valueOf(maxParams), "maxParams");
        this.pathEndIdx = hasPath ? -1 : 0;
    }

    QueryStringDecoder(URI uri) {
        this(uri, StandardCharsets.UTF_8);
    }

    QueryStringDecoder(URI uri, Charset charset) {
        this(uri, charset, 1024);
    }

    QueryStringDecoder(URI uri, Charset charset, int maxParams) {
        String rawQuery;
        String rawPath = uri.getRawPath();
        if (rawPath == null) {
            rawPath = "";
        }
        this.uri = (rawQuery = uri.getRawQuery()) == null ? rawPath : rawPath + '?' + rawQuery;
        this.charset = Objects.requireNonNull(charset, "charset");
        this.maxParams = ArgumentUtils.requirePositive("maxParams", maxParams);
        this.pathEndIdx = rawPath.length();
    }

    public String toString() {
        return this.uri();
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            this.path = QueryStringDecoder.decodeComponent(this.uri, 0, this.pathEndIdx(), this.charset, true);
        }
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        if (this.params == null) {
            this.params = QueryStringDecoder.decodeParams(this.uri, this.pathEndIdx(), this.charset, this.maxParams);
        }
        return this.params;
    }

    public String rawPath() {
        return this.uri.substring(0, this.pathEndIdx());
    }

    public String rawQuery() {
        int start = this.pathEndIdx() + 1;
        return start < this.uri.length() ? this.uri.substring(start) : "";
    }

    private int pathEndIdx() {
        if (this.pathEndIdx == -1) {
            this.pathEndIdx = QueryStringDecoder.findPathEndIndex(this.uri);
        }
        return this.pathEndIdx;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, List<String>> decodeParams(String s, int from, Charset charset, int paramsLimit) {
        int i2;
        int len = s.length();
        if (from >= len) {
            return Collections.emptyMap();
        }
        if (s.charAt(from) == '?') {
            ++from;
        }
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int nameStart = from;
        int valueStart = -1;
        block5: for (i2 = from; i2 < len; ++i2) {
            switch (s.charAt(i2)) {
                case '=': {
                    if (nameStart == i2) {
                        nameStart = i2 + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i2 + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (QueryStringDecoder.addParam(s, nameStart, valueStart, i2, params, charset) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i2 + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        QueryStringDecoder.addParam(s, nameStart, valueStart, i2, params, charset);
        return params;
    }

    public static String decodeComponent(String s) {
        return QueryStringDecoder.decodeComponent(s, StandardCharsets.UTF_8);
    }

    private static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        return QueryStringDecoder.decodeComponent(s, 0, s.length(), charset, false);
    }

    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, Map<String, List<String>> params, Charset charset) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = QueryStringDecoder.decodeComponent(s, nameStart, valueStart - 1, charset, false);
        String value = QueryStringDecoder.decodeComponent(s, valueStart, valueEnd, charset, false);
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, boolean isPath) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        for (int i2 = from; i2 < toExcluded; ++i2) {
            char c = s.charAt(i2);
            if (c != '%' && (c != '+' || isPath)) continue;
            firstEscaped = i2;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        CharsetDecoder decoder = charset.newDecoder();
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        ByteBuffer byteBuf = ByteBuffer.allocate(decodedCapacity);
        CharBuffer charBuf = CharBuffer.allocate(decodedCapacity);
        StringBuilder strBuf = new StringBuilder(len);
        strBuf.append(s, from, firstEscaped);
        for (int i3 = firstEscaped; i3 < toExcluded; ++i3) {
            char c = s.charAt(i3);
            if (c != '%') {
                strBuf.append(c != '+' || isPath ? c : (char)' ');
                continue;
            }
            ((Buffer)byteBuf).clear();
            do {
                if (i3 + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i3 + " of: " + s);
                }
                byteBuf.put(QueryStringDecoder.decodeHexByte(s, i3 + 1));
            } while ((i3 += 3) < toExcluded && s.charAt(i3) == '%');
            --i3;
            ((Buffer)byteBuf).flip();
            ((Buffer)charBuf).clear();
            CoderResult result = decoder.reset().decode(byteBuf, charBuf, true);
            try {
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = decoder.flush(charBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException ex) {
                throw new IllegalStateException(ex);
            }
            strBuf.append(((Buffer)charBuf).flip());
        }
        return strBuf.toString();
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = uri.charAt(i2);
            if (c != '?' && c != '#') continue;
            return i2;
        }
        return len;
    }

    private static byte decodeHexByte(CharSequence s, int pos) {
        int hi = QueryStringDecoder.decodeHexNibble(s.charAt(pos));
        int lo = QueryStringDecoder.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }
}

