/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Optional;

@Internal
public final class AnnotationConvertersRegistrar
implements TypeConverterRegistrar {
    @Override
    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(AnnotationValue.class, Annotation.class, (object, targetType, context) -> {
            Optional<Class> annotationClass = ClassUtils.forName(object.getAnnotationName(), targetType.getClassLoader());
            return annotationClass.map(aClass -> AnnotationMetadataSupport.buildAnnotation(aClass, object));
        });
        conversionService.addConverter(AnnotationValue[].class, Object[].class, (object, targetType, context) -> {
            ArrayList result = new ArrayList();
            Class annotationClass = null;
            for (AnnotationValue annotationValue : object) {
                if (annotationClass == null) {
                    Optional<Class> aClass = ClassUtils.forName(annotationValue.getAnnotationName(), targetType.getClassLoader());
                    if (!aClass.isPresent()) break;
                    annotationClass = aClass.get();
                }
                Object annotation = AnnotationMetadataSupport.buildAnnotation(annotationClass, annotationValue);
                result.add(annotation);
            }
            if (!result.isEmpty()) {
                return Optional.of(result.toArray((Object[])Array.newInstance(annotationClass, result.size())));
            }
            return Optional.empty();
        });
    }
}

