/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.core.annotation.Nullable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.ContextFactory;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.AvailableFeatures;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.options.Options;

public class ListFeatures {
    private final AvailableFeatures availableFeatures;
    private final Options options;
    private final ApplicationType applicationType;
    private final OperatingSystem operatingSystem;
    private final ContextFactory contextFactory;

    public ListFeatures(AvailableFeatures availableFeatures, Options options, ApplicationType applicationType, @Nullable OperatingSystem operatingSystem, ContextFactory contextFactory) {
        this.availableFeatures = availableFeatures;
        this.options = options;
        this.applicationType = applicationType;
        this.operatingSystem = operatingSystem;
        this.contextFactory = contextFactory;
    }

    void output(ConsoleOutput consoleOutput) {
        FeatureContext featureContext = this.contextFactory.createFeatureContext(this.availableFeatures, Collections.emptyList(), this.applicationType, this.options, this.operatingSystem);
        GeneratorContext generatorContext = this.contextFactory.createGeneratorContext(null, featureContext, ConsoleOutput.NOOP);
        Set<Feature> defaultFeatures = generatorContext.getFeatures().getFeatures();
        List allFeatures = this.availableFeatures.getFeatures().collect(Collectors.toList());
        int width = allFeatures.stream().map(Feature::getName).max(Comparator.comparingInt(String::length)).map(String::length).get() + 8;
        Map<String, List<Feature>> featuresByCategory = allFeatures.stream().sorted(Comparator.comparing(Feature::getName)).collect(Collectors.groupingBy(Feature::getCategory));
        featuresByCategory = new TreeMap<String, List<Feature>>(featuresByCategory);
        consoleOutput.out("Available Features");
        consoleOutput.out("@|blue (+)|@ denotes the feature is included by default");
        consoleOutput.out("  " + String.format("%1$-" + width + "s", "Name") + "Description");
        consoleOutput.out("  " + new String(new char[width - 2]).replace("\u0000", "-") + "  ---------------");
        featuresByCategory.forEach((category, features) -> {
            consoleOutput.out("  @|bold,underline,magenta " + category + "|@");
            this.listFeatures(consoleOutput, defaultFeatures, (List<Feature>)features, width);
            consoleOutput.out("");
        });
    }

    private void listFeatures(ConsoleOutput consoleOutput, Set<Feature> defaultFeatures, List<Feature> allFeatures, int width) {
        for (Feature feature : allFeatures) {
            Object name = feature.getName();
            if (feature.isPreview()) {
                name = (String)name + " [PREVIEW]";
            }
            if (feature.isCommunity()) {
                name = (String)name + " [COMMUNITY]";
            }
            if (defaultFeatures.contains(feature)) {
                name = (String)name + " (+)";
                consoleOutput.out("@|blue   " + String.format("%1$-" + width + "s", name) + feature.getDescription() + "|@");
                continue;
            }
            consoleOutput.out("  " + String.format("%1$-" + width + "s", name) + feature.getDescription());
        }
    }
}

