/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.ApplicationFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.lang.LanguageFeature;
import org.grails.forge.feature.test.TestFeature;
import org.grails.forge.options.BuildTool;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.Options;
import org.grails.forge.util.VersionInfo;

public class Features
extends ArrayList<String> {
    private final Set<Feature> featureList;
    private final BuildTool buildTool;
    private final GormImpl gormImpl;
    private final GeneratorContext context;
    private ApplicationFeature applicationFeature;
    private LanguageFeature languageFeature;
    private TestFeature testFeature;
    private final JdkVersion javaVersion;

    public Features(GeneratorContext context, Set<Feature> featureList, Options options) {
        super(featureList.stream().map(Feature::getName).collect(Collectors.toList()));
        this.featureList = featureList;
        this.context = context;
        for (Feature feature : featureList) {
            if (this.applicationFeature == null && feature instanceof ApplicationFeature) {
                this.applicationFeature = (ApplicationFeature)feature;
            }
            if (this.languageFeature == null && feature instanceof LanguageFeature) {
                this.languageFeature = (LanguageFeature)feature;
            }
            if (this.testFeature != null || !(feature instanceof TestFeature)) continue;
            this.testFeature = (TestFeature)feature;
        }
        this.javaVersion = options.getJavaVersion();
        this.buildTool = options.getBuildTool();
        this.gormImpl = options.getGormImpl();
    }

    public BuildTool build() {
        return this.buildTool;
    }

    public ApplicationFeature application() {
        return this.applicationFeature;
    }

    public LanguageFeature language() {
        return this.languageFeature;
    }

    public TestFeature testFramework() {
        return this.testFeature;
    }

    public Set<Feature> getFeatures() {
        return this.featureList;
    }

    public JdkVersion javaVersion() {
        return this.javaVersion;
    }

    public GormImpl gormImpl() {
        return this.gormImpl;
    }

    public Optional<String> mainClass() {
        ApplicationFeature application2 = this.application();
        if (application2 != null && this.context != null) {
            return Optional.ofNullable(application2.mainClassName(this.context));
        }
        return Optional.empty();
    }

    public String getTargetJdk() {
        return VersionInfo.toJdkVersion(this.javaVersion.majorVersion());
    }

    public boolean isFeaturePresent(Class<? extends Feature> feature) {
        Objects.requireNonNull(feature, "The feature class cannot be null");
        return this.getFeatures().stream().map(Object::getClass).anyMatch(feature::isAssignableFrom);
    }

    public <T extends Feature> Optional<T> getFeature(Class<T> feature) {
        Objects.requireNonNull(feature, "The feature class cannot be null");
        for (Feature f : this.featureList) {
            if (!feature.isInstance(f)) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    public <T extends Feature> T getRequiredFeature(Class<T> feature) {
        Objects.requireNonNull(feature, "The feature class cannot be null");
        for (Feature f : this.featureList) {
            if (!feature.isInstance(f)) continue;
            return (T)f;
        }
        throw new IllegalStateException(String.format("The required feature type %s does not exist", feature.getName()));
    }
}

