/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.www.service.WebServiceEditor;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.www.async.AsyncWebService;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AsyncWebServiceEditor
extends MetadataEditor<AsyncWebService> {
    private static final Class<?> PKG = WebServiceEditor.class;
    private Text wName;
    private Button wEnabled;
    private TextVar wFilename;
    private TextVar wStatusVars;
    private TextVar wContentVar;

    public AsyncWebServiceEditor(HopGui hopGui, MetadataManager<AsyncWebService> manager, AsyncWebService metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = props.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        props.setLook((Control)wIcon);
        Label wlName = new Label(parent, 131072);
        props.setLook((Control)wlName);
        wlName.setText("Name");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment((Control)wIcon, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label lastControl = spacer;
        Label wlEnabled = new Label(parent, 131072);
        props.setLook((Control)wlEnabled);
        wlEnabled.setText("Enabled?");
        FormData fdlEnabled = new FormData();
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(middle, 0);
        fdlEnabled.top = new FormAttachment((Control)lastControl, margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(parent, 16416);
        props.setLook((Control)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.left = new FormAttachment(middle, margin);
        fdEnabled.right = new FormAttachment(100, 0);
        fdEnabled.top = new FormAttachment((Control)wlEnabled, 0, 0x1000000);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        lastControl = wlEnabled;
        Label wlFilename = new Label(parent, 131072);
        props.setLook((Control)wlFilename);
        wlFilename.setText("Filename");
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, 0);
        fdlFilename.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbbFilename = new Button(parent, 8);
        props.setLook((Control)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbbFilename = new FormData();
        fdbbFilename.right = new FormAttachment(100, 0);
        fdbbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbbFilename.setLayoutData((Object)fdbbFilename);
        wbbFilename.addListener(13, e -> this.selectWorkflowFilename(parent));
        Button wbnFilename = new Button(parent, 8);
        props.setLook((Control)wbnFilename);
        wbnFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.New", (String[])new String[0]));
        FormData fdbnFilename = new FormData();
        fdbnFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        fdbnFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbnFilename.setLayoutData((Object)fdbnFilename);
        wbnFilename.addListener(13, e -> this.createWorkflowFile(parent));
        Button wboFilename = new Button(parent, 8);
        props.setLook((Control)wboFilename);
        wboFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Open", (String[])new String[0]));
        FormData fdboFilename = new FormData();
        fdboFilename.right = new FormAttachment((Control)wbnFilename, -margin);
        fdboFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wboFilename.setLayoutData((Object)fdboFilename);
        wboFilename.addListener(13, e -> this.openWorkflowFile(parent));
        this.wFilename = new TextVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, margin);
        fdFilename.right = new FormAttachment((Control)wboFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = wlFilename;
        Label wlStatusVars = new Label(parent, 131072);
        props.setLook((Control)wlStatusVars);
        wlStatusVars.setText("Status variables (, separated)");
        FormData fdlStatusVars = new FormData();
        fdlStatusVars.left = new FormAttachment(0, 0);
        fdlStatusVars.right = new FormAttachment(middle, 0);
        fdlStatusVars.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlStatusVars.setLayoutData((Object)fdlStatusVars);
        this.wStatusVars = new TextVar(this.manager.getVariables(), parent, 16416);
        props.setLook((Control)this.wStatusVars);
        FormData fdStatusVars = new FormData();
        fdStatusVars.left = new FormAttachment(middle, margin);
        fdStatusVars.right = new FormAttachment(100, 0);
        fdStatusVars.top = new FormAttachment((Control)wlStatusVars, 0, 0x1000000);
        this.wStatusVars.setLayoutData((Object)fdStatusVars);
        lastControl = wlStatusVars;
        Label wlContentVar = new Label(parent, 131072);
        props.setLook((Control)wlContentVar);
        wlContentVar.setText("Content variable");
        FormData fdlContentVar = new FormData();
        fdlContentVar.left = new FormAttachment(0, 0);
        fdlContentVar.right = new FormAttachment(middle, 0);
        fdlContentVar.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlContentVar.setLayoutData((Object)fdlContentVar);
        this.wContentVar = new TextVar(this.manager.getVariables(), parent, 16416);
        props.setLook((Control)this.wContentVar);
        FormData fdContentVar = new FormData();
        fdContentVar.left = new FormAttachment(middle, margin);
        fdContentVar.right = new FormAttachment(100, 0);
        fdContentVar.top = new FormAttachment((Control)wlContentVar, 0, 0x1000000);
        this.wContentVar.setLayoutData((Object)fdContentVar);
        this.setWidgetsContent();
        ModifyListener lsMod = e -> this.setChanged();
        this.wName.addModifyListener(lsMod);
        this.wEnabled.addListener(13, e -> this.setChanged());
        this.wFilename.addModifyListener(lsMod);
        this.wStatusVars.addModifyListener(lsMod);
        this.wContentVar.addModifyListener(lsMod);
    }

    private void createWorkflowFile(Composite parent) {
        try {
            WorkflowMeta workflowMeta = new WorkflowMeta();
            NotePadMeta note = new NotePadMeta("This workflow can set status variables which are picked up when you request the status of this workflow." + Const.CR + "You can use service asyncStatus to query the status.", 150, 350, -1, -1);
            workflowMeta.addNote(note);
            HopWorkflowFileType type = new HopWorkflowFileType();
            String filename = BaseDialog.presentFileDialog((boolean)true, (Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
            if (filename != null) {
                String realFilename = this.manager.getVariables().resolve(filename);
                workflowMeta.setFilename(realFilename);
                workflowMeta.clearChanged();
                HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
                perspective.activate();
                HopGui.getDataOrchestrationPerspective().addWorkflow(this.hopGui, workflowMeta, type);
                this.hopGui.fileDelegate.fileSave();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error creating workflow", e);
        }
    }

    private void openWorkflowFile(Composite parent) {
        try {
            String filename = this.manager.getVariables().resolve(this.wFilename.getText());
            if (StringUtils.isNotEmpty((String)filename)) {
                this.hopGui.fileDelegate.fileOpen(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), "Error", "Error opening workflow", e);
        }
    }

    private void selectWorkflowFilename(Composite parent) {
        HopWorkflowFileType type = new HopWorkflowFileType();
        BaseDialog.presentFileDialog((Shell)parent.getShell(), (TextVar)this.wFilename, (IVariables)this.manager.getVariables(), (String[])type.getFilterExtensions(), (String[])type.getFilterNames(), (boolean)true);
    }

    public void setWidgetsContent() {
        AsyncWebService ws = (AsyncWebService)this.getMetadata();
        this.wName.setText(Const.NVL((String)ws.getName(), (String)""));
        this.wEnabled.setSelection(ws.isEnabled());
        this.wFilename.setText(Const.NVL((String)ws.getFilename(), (String)""));
        this.wStatusVars.setText(Const.NVL((String)ws.getStatusVariables(), (String)""));
        this.wContentVar.setText(Const.NVL((String)ws.getBodyContentVariable(), (String)""));
    }

    public void getWidgetsContent(AsyncWebService ws) {
        ws.setName(this.wName.getText());
        ws.setEnabled(this.wEnabled.getSelection());
        ws.setFilename(this.wFilename.getText());
        ws.setStatusVariables(this.wStatusVars.getText());
        ws.setBodyContentVariable(this.wContentVar.getText());
    }

    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }
}

