/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class PaperDocCreateUpdateResult {
    protected final String docId;
    protected final long revision;
    protected final String title;

    public PaperDocCreateUpdateResult(String docId, long revision, String title) {
        if (docId == null) {
            throw new IllegalArgumentException("Required value for 'docId' is null");
        }
        this.docId = docId;
        this.revision = revision;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        this.title = title;
    }

    public String getDocId() {
        return this.docId;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.docId, this.revision, this.title});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocCreateUpdateResult other = (PaperDocCreateUpdateResult)obj;
            return !(this.docId != other.docId && !this.docId.equals(other.docId) || this.revision != other.revision || this.title != other.title && !this.title.equals(other.title));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocCreateUpdateResult> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocCreateUpdateResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("doc_id");
            StoneSerializers.string().serialize(value.docId, g);
            g.writeFieldName("revision");
            StoneSerializers.int64().serialize((Long)value.revision, g);
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperDocCreateUpdateResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_title;
            Long f_revision;
            String f_docId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docId = null;
                f_revision = null;
                f_title = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_id".equals(field)) {
                        f_docId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("revision".equals(field)) {
                        f_revision = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docId == null) {
                    throw new JsonParseException(p, "Required field \"doc_id\" missing.");
                }
                if (f_revision == null) {
                    throw new JsonParseException(p, "Required field \"revision\" missing.");
                }
                if (f_title == null) {
                    throw new JsonParseException(p, "Required field \"title\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocCreateUpdateResult value = new PaperDocCreateUpdateResult(f_docId, f_revision, f_title);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

