/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerSequence;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;

@HopServerServlet(id="nextSequence", name="Get the next block of values for a sequence")
public class NextSequenceValueServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/hop/nextSequence";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_INCREMENT = "increment";
    public static final String XML_TAG = "seq";
    public static final String XML_TAG_VALUE = "value";
    public static final String XML_TAG_INCREMENT = "increment";
    public static final String XML_TAG_ERROR = "error";

    public NextSequenceValueServlet() {
    }

    public NextSequenceValueServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(this.toString());
        }
        String name = request.getParameter(PARAM_NAME);
        long increment = Const.toLong((String)request.getParameter("increment"), (long)10000L);
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.println(XmlHandler.getXmlHeader((String)"UTF-8"));
        out.println(XmlHandler.openTag((String)XML_TAG));
        try {
            HopServerSequence hopServerSequence = this.getPipelineMap().getServerSequence(name);
            if (hopServerSequence == null && this.getPipelineMap().isAutomaticServerSequenceCreationAllowed()) {
                hopServerSequence = this.getPipelineMap().createServerSequence(name);
            }
            if (hopServerSequence == null) {
                response.sendError(404);
                out.println(XmlHandler.addTagValue((String)XML_TAG_ERROR, (String)("Server sequence '" + name + "' could not be found.")));
            } else {
                SimpleLoggingObject loggingObject = new SimpleLoggingObject("HopServer", LoggingObjectType.HOP_SERVER, null);
                long nextValue = hopServerSequence.getNextValue(this.variables, (ILoggingObject)loggingObject, increment);
                out.println(XmlHandler.addTagValue((String)XML_TAG_VALUE, (long)nextValue));
                out.println(XmlHandler.addTagValue((String)"increment", (long)increment));
            }
        }
        catch (Exception e) {
            response.sendError(404);
            out.println(XmlHandler.addTagValue((String)XML_TAG_ERROR, (String)("Error retrieving next value from server sequence: " + Const.getStackTracker((Throwable)e))));
        }
        out.println(XmlHandler.closeTag((String)XML_TAG));
    }

    public String toString() {
        return "Retrieve the next value of hop server sequence requested.";
    }

    @Override
    public String getService() {
        return "/hop/nextSequence (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

