/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueMetaAndData;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class Condition
implements Cloneable {
    public static final String XML_TAG = "condition";
    public static final String[] operators = new String[]{"-", "OR", "AND", "NOT", "OR NOT", "AND NOT", "XOR"};
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_OR = 1;
    public static final int OPERATOR_AND = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_OR_NOT = 4;
    public static final int OPERATOR_AND_NOT = 5;
    public static final int OPERATOR_XOR = 6;
    public static final String[] functions = new String[]{"=", "<>", "<", "<=", ">", ">=", "REGEXP", "IS NULL", "IS NOT NULL", "IN LIST", "CONTAINS", "STARTS WITH", "ENDS WITH", "LIKE", "TRUE"};
    public static final int FUNC_EQUAL = 0;
    public static final int FUNC_NOT_EQUAL = 1;
    public static final int FUNC_SMALLER = 2;
    public static final int FUNC_SMALLER_EQUAL = 3;
    public static final int FUNC_LARGER = 4;
    public static final int FUNC_LARGER_EQUAL = 5;
    public static final int FUNC_REGEXP = 6;
    public static final int FUNC_NULL = 7;
    public static final int FUNC_NOT_NULL = 8;
    public static final int FUNC_IN_LIST = 9;
    public static final int FUNC_CONTAINS = 10;
    public static final int FUNC_STARTS_WITH = 11;
    public static final int FUNC_ENDS_WITH = 12;
    public static final int FUNC_LIKE = 13;
    public static final int FUNC_TRUE = 14;
    private boolean negate = false;
    private int operator = 0;
    private String leftValuename;
    private int function;
    private String rightValuename;
    private ValueMetaAndData rightExact;
    private int leftFieldnr = -2;
    private int rightFieldnr = -2;
    private List<Condition> list = new ArrayList<Condition>();
    private String rightString;
    private String[] inList;

    public Condition() {
    }

    public Condition(String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this();
        this.leftValuename = valuename;
        this.function = function;
        this.rightValuename = valuename2;
        this.rightExact = exact;
        this.clearFieldPositions();
    }

    public Condition(int operator, String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this();
        this.operator = operator;
        this.leftValuename = valuename;
        this.function = function;
        this.rightValuename = valuename2;
        this.rightExact = exact;
        this.clearFieldPositions();
    }

    public Condition(boolean negate, String valuename, int function, String valuename2, ValueMetaAndData exact) {
        this(valuename, function, valuename2, exact);
        this.negate = negate;
    }

    public Object clone() {
        Condition retval = null;
        retval = new Condition();
        retval.negate = this.negate;
        retval.operator = this.operator;
        if (this.isComposite()) {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                Condition cCopy = (Condition)c.clone();
                retval.addCondition(cCopy);
            }
        } else {
            retval.negate = this.negate;
            retval.leftValuename = this.leftValuename;
            retval.operator = this.operator;
            retval.rightValuename = this.rightValuename;
            retval.function = this.function;
            retval.rightExact = this.rightExact != null ? (ValueMetaAndData)this.rightExact.clone() : null;
        }
        return retval;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getOperatorDesc() {
        return Const.rightPad(operators[this.operator], 7);
    }

    public static final int getOperator(String description) {
        if (description == null) {
            return 0;
        }
        for (int i = 1; i < operators.length; ++i) {
            if (!operators[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public static final String[] getOperators() {
        String[] retval = new String[operators.length - 1];
        for (int i = 1; i < operators.length; ++i) {
            retval[i - 1] = operators[i];
        }
        return retval;
    }

    public static final String[] getRealOperators() {
        return new String[]{"OR", "AND", "OR NOT", "AND NOT", "XOR"};
    }

    public void setLeftValuename(String leftValuename) {
        this.leftValuename = leftValuename;
    }

    public String getLeftValuename() {
        return this.leftValuename;
    }

    public int getFunction() {
        return this.function;
    }

    public void setFunction(int function) {
        this.function = function;
    }

    public String getFunctionDesc() {
        return functions[this.function];
    }

    public static final int getFunction(String description) {
        for (int i = 1; i < functions.length; ++i) {
            if (!functions[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public void setRightValuename(String rightValuename) {
        this.rightValuename = rightValuename;
    }

    public String getRightValuename() {
        return this.rightValuename;
    }

    public void setRightExact(ValueMetaAndData rightExact) {
        this.rightExact = rightExact;
    }

    public ValueMetaAndData getRightExact() {
        return this.rightExact;
    }

    public String getRightExactString() {
        if (this.rightExact == null) {
            return null;
        }
        return this.rightExact.toString();
    }

    public boolean isAtomic() {
        return this.list.isEmpty();
    }

    public boolean isComposite() {
        return !this.list.isEmpty();
    }

    public boolean isNegated() {
        return this.negate;
    }

    public void setNegated(boolean negate) {
        this.negate = negate;
    }

    public void negate() {
        this.setNegated(!this.isNegated());
    }

    public boolean isEmpty() {
        return this.isAtomic() && this.leftValuename == null;
    }

    public void clearFieldPositions() {
        this.leftFieldnr = -2;
        this.rightFieldnr = -2;
    }

    public boolean evaluate(IRowMeta rowMeta, Object[] r) {
        boolean retval = false;
        try {
            if (this.isAtomic()) {
                Object field2;
                if (this.function == 14) {
                    return !this.negate;
                }
                if (this.leftValuename != null && this.leftValuename.length() > 0) {
                    this.leftFieldnr = rowMeta.indexOfValue(this.leftValuename);
                }
                if (this.rightValuename != null && this.rightValuename.length() > 0) {
                    this.rightFieldnr = rowMeta.indexOfValue(this.rightValuename);
                }
                IValueMeta fieldMeta = null;
                Object field = null;
                if (this.leftFieldnr < 0) {
                    return false;
                }
                fieldMeta = rowMeta.getValueMeta(this.leftFieldnr);
                field = r[this.leftFieldnr];
                IValueMeta fieldMeta2 = this.rightExact != null ? this.rightExact.getValueMeta() : null;
                Object object = field2 = this.rightExact != null ? this.rightExact.getValueData() : null;
                if (field2 == null && this.rightFieldnr >= 0) {
                    fieldMeta2 = rowMeta.getValueMeta(this.rightFieldnr);
                    field2 = r[this.rightFieldnr];
                }
                switch (this.function) {
                    case 0: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) == 0;
                        break;
                    }
                    case 1: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) != 0;
                        break;
                    }
                    case 2: {
                        if (fieldMeta.isNull(field)) {
                            retval = false;
                            break;
                        }
                        retval = fieldMeta.compare(field, fieldMeta2, field2) < 0;
                        break;
                    }
                    case 3: {
                        if (fieldMeta.isNull(field)) {
                            retval = false;
                            break;
                        }
                        retval = fieldMeta.compare(field, fieldMeta2, field2) <= 0;
                        break;
                    }
                    case 4: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) > 0;
                        break;
                    }
                    case 5: {
                        retval = fieldMeta.compare(field, fieldMeta2, field2) >= 0;
                        break;
                    }
                    case 6: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            retval = false;
                            break;
                        }
                        retval = Pattern.matches(fieldMeta2.getCompatibleString(field2), fieldMeta.getCompatibleString(field));
                        break;
                    }
                    case 7: {
                        retval = fieldMeta.isNull(field);
                        break;
                    }
                    case 8: {
                        retval = !fieldMeta.isNull(field);
                        break;
                    }
                    case 9: {
                        if (this.inList == null || this.rightFieldnr >= 0) {
                            this.inList = Const.splitString(fieldMeta2.getString(field2), ';', true);
                            for (int i = 0; i < this.inList.length; ++i) {
                                this.inList[i] = this.inList[i] == null ? null : this.inList[i].replace("\\", "");
                            }
                            Arrays.sort(this.inList);
                        }
                        String searchString = fieldMeta.getCompatibleString(field);
                        int inIndex = -1;
                        if (searchString != null) {
                            inIndex = Arrays.binarySearch(this.inList, searchString);
                        }
                        retval = inIndex >= 0;
                        break;
                    }
                    case 10: {
                        retval = fieldMeta.getCompatibleString(field) != null ? fieldMeta.getCompatibleString(field).indexOf(fieldMeta2.getCompatibleString(field2)) >= 0 : false;
                        break;
                    }
                    case 11: {
                        retval = fieldMeta.getCompatibleString(field) != null ? fieldMeta.getCompatibleString(field).startsWith(fieldMeta2.getCompatibleString(field2)) : false;
                        break;
                    }
                    case 12: {
                        String string = fieldMeta.getCompatibleString(field);
                        if (!Utils.isEmpty(string)) {
                            if (this.rightString == null && field2 != null) {
                                this.rightString = fieldMeta2.getCompatibleString(field2);
                            }
                            if (this.rightString != null) {
                                retval = string.endsWith(fieldMeta2.getCompatibleString(field2));
                                break;
                            }
                            retval = false;
                            break;
                        }
                        retval = false;
                        break;
                    }
                    case 13: {
                        if (fieldMeta.isNull(field) || field2 == null) {
                            retval = false;
                            break;
                        }
                        String regex = fieldMeta2.getCompatibleString(field2);
                        regex = regex.replace("%", ".*");
                        regex = regex.replace("?", ".");
                        retval = Pattern.matches(regex, fieldMeta.getCompatibleString(field));
                        break;
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            } else {
                Condition cb0 = this.list.get(0);
                retval = cb0.evaluate(rowMeta, r);
                block26: for (int i = 1; i < this.list.size(); ++i) {
                    Condition cb = this.list.get(i);
                    switch (cb.getOperator()) {
                        case 1: {
                            retval = retval || cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 2: {
                            retval = retval && cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 4: {
                            retval = retval || !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 5: {
                            retval = retval && !cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                        case 6: {
                            retval ^= cb.evaluate(rowMeta, r);
                            continue block26;
                        }
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error evaluation condition [" + this.toString() + "]", e);
        }
        return retval;
    }

    public void addCondition(Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(cb);
    }

    public void addCondition(int idx, Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && idx > 0 && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(idx, cb);
    }

    public void removeCondition(int nr) {
        if (this.isComposite()) {
            boolean moveUp;
            Condition c = this.list.get(nr);
            this.list.remove(nr);
            boolean bl = moveUp = this.isAtomic() || this.nrConditions() == 1;
            if (this.nrConditions() == 1) {
                c = this.getCondition(0);
            }
            if (moveUp) {
                this.setLeftValuename(c.getLeftValuename());
                this.setFunction(c.getFunction());
                this.setRightValuename(c.getRightValuename());
                this.setRightExact(c.getRightExact());
                this.setNegated(this.isNegated() ^ c.isNegated());
            }
        }
    }

    public boolean simplify() {
        Condition condition;
        if (this.nrConditions() == 1 && (condition = this.getCondition(0)).isAtomic()) {
            return this.simplify(condition, this);
        }
        boolean changed = false;
        for (int i = 0; i < this.nrConditions(); ++i) {
            Condition condition2 = this.getCondition(i);
            changed |= condition2.simplify();
            if (i != 0) continue;
            condition2.setOperator(0);
        }
        return changed;
    }

    private boolean simplify(Condition condition, Condition parent) {
        if (condition.isAtomic() && parent.nrConditions() == 1) {
            parent.setLeftValuename(condition.getLeftValuename());
            parent.setFunction(condition.getFunction());
            parent.setRightValuename(condition.getRightValuename());
            parent.setRightExact(condition.getRightExact());
            parent.setNegated(condition.isNegated() ^ parent.isNegated());
            parent.list.clear();
            return true;
        }
        return false;
    }

    public int nrConditions() {
        return this.list.size();
    }

    public Condition getCondition(int i) {
        return this.list.get(i);
    }

    public void setCondition(int i, Condition subCondition) {
        this.list.set(i, subCondition);
    }

    public String toString() {
        return this.toString(0, true, true);
    }

    public String toString(int level, boolean showNegate, boolean showOperator) {
        StringBuilder retval = new StringBuilder();
        if (this.isAtomic()) {
            for (int i = 0; i < level; ++i) {
                retval.append("  ");
            }
            if (showOperator && this.getOperator() != 0) {
                retval.append(this.getOperatorDesc());
                retval.append(" ");
            } else {
                retval.append("        ");
            }
            if (this.isNegated() && (showNegate || level > 0)) {
                retval.append("NOT ( ");
            } else {
                retval.append("      ");
            }
            if (this.function == 14) {
                retval.append(" TRUE");
            } else {
                retval.append(this.leftValuename + " " + this.getFunctionDesc());
                if (this.function != 7 && this.function != 8) {
                    if (this.rightValuename != null) {
                        retval.append(" ");
                        retval.append(this.rightValuename);
                    } else {
                        retval.append(" [" + (this.getRightExactString() == null ? "" : this.getRightExactString()) + "]");
                    }
                }
            }
            if (this.isNegated() && (showNegate || level > 0)) {
                retval.append(" )");
            }
            retval.append(Const.CR);
        } else {
            int i;
            if (this.isNegated() && (showNegate || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval.append("  ");
                }
                retval.append("NOT");
                retval.append(Const.CR);
            }
            if (this.getOperator() != 0 && (showOperator || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval.append("  ");
                }
                retval.append(this.getOperatorDesc());
                retval.append(Const.CR);
            }
            for (i = 0; i < level; ++i) {
                retval.append("  ");
            }
            retval.append("(" + Const.CR);
            for (i = 0; i < this.list.size(); ++i) {
                Condition cb = this.list.get(i);
                retval.append(cb.toString(level + 1, true, i > 0));
            }
            for (i = 0; i < level; ++i) {
                retval.append("  ");
            }
            retval.append(")");
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String getXml() throws HopValueException {
        return this.getXML(0);
    }

    public String getXML(int level) throws HopValueException {
        Object retval = "";
        String indent1 = Const.rightPad(" ", level);
        String indent2 = Const.rightPad(" ", level + 1);
        String indent3 = Const.rightPad(" ", level + 2);
        retval = (String)retval + indent1 + XmlHandler.openTag(XML_TAG) + Const.CR;
        retval = (String)retval + indent2 + XmlHandler.addTagValue("negated", this.isNegated());
        if (this.getOperator() != 0) {
            retval = (String)retval + indent2 + XmlHandler.addTagValue("operator", Const.rtrim(this.getOperatorDesc()));
        }
        if (this.isAtomic()) {
            retval = (String)retval + indent2 + XmlHandler.addTagValue("leftvalue", this.getLeftValuename());
            retval = (String)retval + indent2 + XmlHandler.addTagValue("function", this.getFunctionDesc());
            retval = (String)retval + indent2 + XmlHandler.addTagValue("rightvalue", this.getRightValuename());
            if (this.getRightExact() != null) {
                retval = (String)retval + indent2 + this.getRightExact().getXml();
            }
        } else {
            retval = (String)retval + indent2 + "<conditions>" + Const.CR;
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                retval = (String)retval + c.getXML(level + 2);
            }
            retval = (String)retval + indent3 + "</conditions>" + Const.CR;
        }
        retval = (String)retval + indent2 + XmlHandler.closeTag(XML_TAG) + Const.CR;
        return retval;
    }

    public Condition(String xml) throws HopXmlException {
        this(XmlHandler.loadXmlString(xml, XML_TAG));
    }

    public Condition(Node condnode) throws HopXmlException {
        this();
        this.list = new ArrayList<Condition>();
        try {
            String strNegated = XmlHandler.getTagValue(condnode, "negated");
            this.setNegated("Y".equalsIgnoreCase(strNegated));
            String strOperator = XmlHandler.getTagValue(condnode, "operator");
            this.setOperator(Condition.getOperator(strOperator));
            Node conditions = XmlHandler.getSubNode(condnode, "conditions");
            int nrconditions = XmlHandler.countNodes(conditions, XML_TAG);
            if (nrconditions == 0) {
                this.setLeftValuename(XmlHandler.getTagValue(condnode, "leftvalue"));
                this.setFunction(Condition.getFunction(XmlHandler.getTagValue(condnode, "function")));
                this.setRightValuename(XmlHandler.getTagValue(condnode, "rightvalue"));
                Node exactnode = XmlHandler.getSubNode(condnode, "value");
                if (exactnode != null) {
                    ValueMetaAndData exact = new ValueMetaAndData(exactnode);
                    this.setRightExact(exact);
                }
            } else {
                for (int i = 0; i < nrconditions; ++i) {
                    Node subcondnode = XmlHandler.getSubNodeByNr(conditions, XML_TAG, i);
                    Condition c = new Condition(subcondnode);
                    this.addCondition(c);
                }
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to create condition using xml: " + Const.CR + condnode, e);
        }
    }

    public String[] getUsedFields() {
        Hashtable<String, String> fields = new Hashtable<String, String>();
        this.getUsedFields(fields);
        String[] retval = new String[fields.size()];
        Enumeration<String> keys = fields.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = keys.nextElement();
            ++i;
        }
        return retval;
    }

    public void getUsedFields(Map<String, String> fields) {
        if (this.isAtomic()) {
            if (this.getLeftValuename() != null) {
                fields.put(this.getLeftValuename(), "-");
            }
            if (this.getRightValuename() != null) {
                fields.put(this.getRightValuename(), "-");
            }
        } else {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition subc = this.getCondition(i);
                subc.getUsedFields(fields);
            }
        }
    }

    public List<Condition> getChildren() {
        return this.list;
    }
}

