/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class HttpClientManager {
    private static final int CONNECTIONS_PER_ROUTE = 100;
    private static final int TOTAL_CONNECTIONS = 200;
    private static HttpClientManager httpClientManager;
    private static PoolingHttpClientConnectionManager manager;

    private HttpClientManager() {
        manager = new PoolingHttpClientConnectionManager();
        manager.setDefaultMaxPerRoute(100);
        manager.setMaxTotal(200);
    }

    public static HttpClientManager getInstance() {
        if (httpClientManager == null) {
            httpClientManager = new HttpClientManager();
        }
        return httpClientManager;
    }

    public CloseableHttpClient createDefaultClient() {
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).build();
    }

    public HttpClientBuilderFacade createBuilder() {
        return new HttpClientBuilderFacade();
    }

    public static SSLContext getSslContextWithTrustStoreFile(FileInputStream trustFileStream, String trustStorePassword) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, KeyManagementException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)tm;
            break;
        }
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(trustFileStream, trustStorePassword.toCharArray());
        trustFileStream.close();
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustStore);
        X509TrustManager trustManager = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)tm;
            break;
        }
        final X509TrustManager finalDefaultTm = defaultTm;
        final X509TrustManager finalTrustManager = trustManager;
        X509TrustManager customTm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return finalDefaultTm.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    finalTrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    finalDefaultTm.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                finalDefaultTm.checkClientTrusted(chain, authType);
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, new TrustManager[]{customTm}, null);
        return sslContext;
    }

    public static SSLContext getTrustAllSslContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc;
    }

    public static HostnameVerifier getHostnameVerifier(boolean isDebug, ILogChannel log) {
        return (hostname, session) -> {
            if (isDebug) {
                log.logDebug("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
            }
            return true;
        };
    }

    public class HttpClientBuilderFacade {
        private RedirectStrategy redirectStrategy;
        private CredentialsProvider provider;
        private int connectionTimeout;
        private int socketTimeout;
        private HttpHost proxy;
        private boolean ignoreSsl;

        public HttpClientBuilderFacade setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public HttpClientBuilderFacade setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public HttpClientBuilderFacade setCredentials(String user, String password, AuthScope authScope) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
            provider.setCredentials(authScope, (Credentials)credentials);
            this.provider = provider;
            return this;
        }

        public HttpClientBuilderFacade setCredentials(String user, String password) {
            return this.setCredentials(user, password, AuthScope.ANY);
        }

        public HttpClientBuilderFacade setProxy(String proxyHost, int proxyPort) {
            this.setProxy(proxyHost, proxyPort, "http");
            return this;
        }

        public HttpClientBuilderFacade setProxy(String proxyHost, int proxyPort, String scheme) {
            this.proxy = new HttpHost(proxyHost, proxyPort, scheme);
            return this;
        }

        public HttpClientBuilderFacade setRedirect(RedirectStrategy redirectStrategy) {
            this.redirectStrategy = redirectStrategy;
            return this;
        }

        public void ignoreSsl(boolean ignoreSsl) {
            this.ignoreSsl = ignoreSsl;
        }

        public void ignoreSsl(HttpClientBuilder httpClientBuilder) {
            SSLContext sslContext;
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)connectionManager);
        }

        public CloseableHttpClient build() {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)manager);
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            if (this.socketTimeout > 0) {
                requestConfigBuilder.setSocketTimeout(this.socketTimeout);
            }
            if (this.connectionTimeout > 0) {
                requestConfigBuilder.setConnectTimeout(this.socketTimeout);
            }
            if (this.proxy != null) {
                requestConfigBuilder.setProxy(this.proxy);
            }
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            if (this.provider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(this.provider);
            }
            if (this.redirectStrategy != null) {
                httpClientBuilder.setRedirectStrategy(this.redirectStrategy);
            }
            if (this.ignoreSsl) {
                this.ignoreSsl(httpClientBuilder);
            }
            return httpClientBuilder.build();
        }
    }
}

