/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforsql;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.waitforsql.ActionWaitForSql;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionWaitForSqlDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionWaitForSql.class;
    private Button wbTable;
    private Button wbSqlTable;
    private Text wName;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private ActionWaitForSql action;
    private boolean changed;
    private Label wlUseSubs;
    private Button wUseSubs;
    private Label wlAddRowsToResult;
    private Button wAddRowsToResult;
    private Button wCustomSql;
    private Label wlSql;
    private StyledTextComp wSql;
    private Label wlPosition;
    private Label wlSchemaname;
    private TextVar wSchemaname;
    private Label wlTablename;
    private TextVar wTablename;
    private CCombo wSuccessCondition;
    private TextVar wRowsCountValue;
    private TextVar wMaximumTimeout;
    private TextVar wCheckCycleTime;
    private Button wSuccessOnTimeout;
    private Label wlClearResultList;
    private Button wClearResultList;

    public ActionWaitForSqlDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionWaitForSql)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, this.action.getDatabase(), lsMod);
        this.wlSchemaname = new Label((Composite)this.shell, 131072);
        this.wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Schemaname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchemaname);
        FormData fdlSchemaname = new FormData();
        fdlSchemaname.left = new FormAttachment(0, 0);
        fdlSchemaname.right = new FormAttachment(middle, 0);
        fdlSchemaname.top = new FormAttachment(this.wConnection, margin);
        this.wlSchemaname.setLayoutData((Object)fdlSchemaname);
        this.wSchemaname = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        FormData fdSchemaname = new FormData();
        fdSchemaname.left = new FormAttachment(middle, 0);
        fdSchemaname.top = new FormAttachment(this.wConnection, margin);
        fdSchemaname.right = new FormAttachment(100, 0);
        this.wSchemaname.setLayoutData((Object)fdSchemaname);
        this.wlTablename = new Label((Composite)this.shell, 131072);
        this.wlTablename.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Tablename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTablename);
        FormData fdlTablename = new FormData();
        fdlTablename.left = new FormAttachment(0, 0);
        fdlTablename.right = new FormAttachment(middle, 0);
        fdlTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        this.wlTablename.setLayoutData((Object)fdlTablename);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchemaname, margin / 2);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.getTableName();
            }
        });
        this.wTablename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTablename);
        this.wTablename.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Tablename.Tooltip", (String[])new String[0]));
        this.wTablename.addModifyListener(lsMod);
        FormData fdTablename = new FormData();
        fdTablename.left = new FormAttachment(middle, 0);
        fdTablename.top = new FormAttachment((Control)this.wSchemaname, margin);
        fdTablename.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTablename.setLayoutData((Object)fdTablename);
        Group wSuccessGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wSuccessGroup);
        wSuccessGroup.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessGroup.Group.Label", (String[])new String[0]));
        FormLayout successGroupLayout = new FormLayout();
        successGroupLayout.marginWidth = 10;
        successGroupLayout.marginHeight = 10;
        wSuccessGroup.setLayout((Layout)successGroupLayout);
        Label wlSuccessCondition = new Label((Composite)wSuccessGroup, 131072);
        wlSuccessCondition.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessCondition.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSuccessCondition);
        FormData fdlSuccessCondition = new FormData();
        fdlSuccessCondition.left = new FormAttachment(0, -margin);
        fdlSuccessCondition.right = new FormAttachment(middle, -2 * margin);
        fdlSuccessCondition.top = new FormAttachment(0, margin);
        wlSuccessCondition.setLayoutData((Object)fdlSuccessCondition);
        this.wSuccessCondition = new CCombo((Composite)wSuccessGroup, 2060);
        this.wSuccessCondition.setItems(ActionWaitForSql.successConditionsDesc);
        this.wSuccessCondition.select(0);
        this.props.setLook((Control)this.wSuccessCondition);
        FormData fdSuccessCondition = new FormData();
        fdSuccessCondition.left = new FormAttachment(middle, -margin);
        fdSuccessCondition.top = new FormAttachment(0, margin);
        fdSuccessCondition.right = new FormAttachment(100, 0);
        this.wSuccessCondition.setLayoutData((Object)fdSuccessCondition);
        this.wSuccessCondition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Label wlRowsCountValue = new Label((Composite)wSuccessGroup, 131072);
        wlRowsCountValue.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.RowsCountValue.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRowsCountValue);
        FormData fdlRowsCountValue = new FormData();
        fdlRowsCountValue.left = new FormAttachment(0, -margin);
        fdlRowsCountValue.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdlRowsCountValue.right = new FormAttachment(middle, -2 * margin);
        wlRowsCountValue.setLayoutData((Object)fdlRowsCountValue);
        this.wRowsCountValue = new TextVar(this.variables, (Composite)wSuccessGroup, 18436, BaseMessages.getString(PKG, (String)"ActionWaitForSQL.RowsCountValue.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRowsCountValue);
        this.wRowsCountValue.addModifyListener(lsMod);
        FormData fdRowsCountValue = new FormData();
        fdRowsCountValue.left = new FormAttachment(middle, -margin);
        fdRowsCountValue.top = new FormAttachment((Control)this.wSuccessCondition, margin);
        fdRowsCountValue.right = new FormAttachment(100, 0);
        this.wRowsCountValue.setLayoutData((Object)fdRowsCountValue);
        Label wlMaximumTimeout = new Label((Composite)wSuccessGroup, 131072);
        wlMaximumTimeout.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.MaximumTimeout.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaximumTimeout);
        FormData fdlMaximumTimeout = new FormData();
        fdlMaximumTimeout.left = new FormAttachment(0, -margin);
        fdlMaximumTimeout.top = new FormAttachment((Control)this.wRowsCountValue, margin);
        fdlMaximumTimeout.right = new FormAttachment(middle, -2 * margin);
        wlMaximumTimeout.setLayoutData((Object)fdlMaximumTimeout);
        this.wMaximumTimeout = new TextVar(this.variables, (Composite)wSuccessGroup, 18436);
        this.props.setLook((Control)this.wMaximumTimeout);
        this.wMaximumTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.MaximumTimeout.Tooltip", (String[])new String[0]));
        this.wMaximumTimeout.addModifyListener(lsMod);
        FormData fdMaximumTimeout = new FormData();
        fdMaximumTimeout.left = new FormAttachment(middle, -margin);
        fdMaximumTimeout.top = new FormAttachment((Control)this.wRowsCountValue, margin);
        fdMaximumTimeout.right = new FormAttachment(100, 0);
        this.wMaximumTimeout.setLayoutData((Object)fdMaximumTimeout);
        Label wlCheckCycleTime = new Label((Composite)wSuccessGroup, 131072);
        wlCheckCycleTime.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.CheckCycleTime.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCheckCycleTime);
        FormData fdlCheckCycleTime = new FormData();
        fdlCheckCycleTime.left = new FormAttachment(0, -margin);
        fdlCheckCycleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        fdlCheckCycleTime.right = new FormAttachment(middle, -2 * margin);
        wlCheckCycleTime.setLayoutData((Object)fdlCheckCycleTime);
        this.wCheckCycleTime = new TextVar(this.variables, (Composite)wSuccessGroup, 18436);
        this.props.setLook((Control)this.wCheckCycleTime);
        this.wCheckCycleTime.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.CheckCycleTime.Tooltip", (String[])new String[0]));
        this.wCheckCycleTime.addModifyListener(lsMod);
        FormData fdCheckCycleTime = new FormData();
        fdCheckCycleTime.left = new FormAttachment(middle, -margin);
        fdCheckCycleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        fdCheckCycleTime.right = new FormAttachment(100, 0);
        this.wCheckCycleTime.setLayoutData((Object)fdCheckCycleTime);
        Label wlSuccessOnTimeout = new Label((Composite)wSuccessGroup, 131072);
        wlSuccessOnTimeout.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessOnTimeout.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSuccessOnTimeout);
        FormData fdlSuccessOnTimeout = new FormData();
        fdlSuccessOnTimeout.left = new FormAttachment(0, -margin);
        fdlSuccessOnTimeout.top = new FormAttachment((Control)this.wCheckCycleTime, margin);
        fdlSuccessOnTimeout.right = new FormAttachment(middle, -2 * margin);
        wlSuccessOnTimeout.setLayoutData((Object)fdlSuccessOnTimeout);
        this.wSuccessOnTimeout = new Button((Composite)wSuccessGroup, 32);
        this.props.setLook((Control)this.wSuccessOnTimeout);
        this.wSuccessOnTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessOnTimeout.Tooltip", (String[])new String[0]));
        FormData fdSuccessOnTimeout = new FormData();
        fdSuccessOnTimeout.left = new FormAttachment(middle, -margin);
        fdSuccessOnTimeout.top = new FormAttachment((Control)wlSuccessOnTimeout, 0, 0x1000000);
        fdSuccessOnTimeout.right = new FormAttachment(100, -margin);
        this.wSuccessOnTimeout.setLayoutData((Object)fdSuccessOnTimeout);
        this.wSuccessOnTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.action.setChanged();
            }
        });
        FormData fdSuccessGroup = new FormData();
        fdSuccessGroup.left = new FormAttachment(0, margin);
        fdSuccessGroup.top = new FormAttachment((Control)this.wbTable, margin);
        fdSuccessGroup.right = new FormAttachment(100, -margin);
        wSuccessGroup.setLayoutData((Object)fdSuccessGroup);
        Group wCustomGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wCustomGroup);
        wCustomGroup.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.CustomGroup.Group.Label", (String[])new String[0]));
        FormLayout customGroupLayout = new FormLayout();
        customGroupLayout.marginWidth = 10;
        customGroupLayout.marginHeight = 10;
        wCustomGroup.setLayout((Layout)customGroupLayout);
        Label wlCustomSql = new Label((Composite)wCustomGroup, 131072);
        wlCustomSql.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.customSQL.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCustomSql);
        FormData fdlCustomSql = new FormData();
        fdlCustomSql.left = new FormAttachment(0, -margin);
        fdlCustomSql.top = new FormAttachment((Control)wSuccessGroup, margin);
        fdlCustomSql.right = new FormAttachment(middle, -2 * margin);
        wlCustomSql.setLayoutData((Object)fdlCustomSql);
        this.wCustomSql = new Button((Composite)wCustomGroup, 32);
        this.props.setLook((Control)this.wCustomSql);
        this.wCustomSql.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.customSQL.Tooltip", (String[])new String[0]));
        FormData fdCustomSql = new FormData();
        fdCustomSql.left = new FormAttachment(middle, -margin);
        fdCustomSql.top = new FormAttachment((Control)wlCustomSql, 0, 0x1000000);
        fdCustomSql.right = new FormAttachment(100, 0);
        this.wCustomSql.setLayoutData((Object)fdCustomSql);
        this.wCustomSql.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.setCustomerSql();
                ActionWaitForSqlDialog.this.action.setChanged();
            }
        });
        this.wlUseSubs = new Label((Composite)wCustomGroup, 131072);
        this.wlUseSubs.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.UseVariableSubst.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUseSubs);
        FormData fdlUseSubs = new FormData();
        fdlUseSubs.left = new FormAttachment(0, -margin);
        fdlUseSubs.top = new FormAttachment((Control)wlCustomSql, 2 * margin);
        fdlUseSubs.right = new FormAttachment(middle, -2 * margin);
        this.wlUseSubs.setLayoutData((Object)fdlUseSubs);
        this.wUseSubs = new Button((Composite)wCustomGroup, 32);
        this.props.setLook((Control)this.wUseSubs);
        this.wUseSubs.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.UseVariableSubst.Tooltip", (String[])new String[0]));
        FormData fdUseSubs = new FormData();
        fdUseSubs.left = new FormAttachment(middle, -margin);
        fdUseSubs.top = new FormAttachment((Control)this.wlUseSubs, 0, 0x1000000);
        fdUseSubs.right = new FormAttachment(100, 0);
        this.wUseSubs.setLayoutData((Object)fdUseSubs);
        this.wUseSubs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.action.setChanged();
            }
        });
        this.wlClearResultList = new Label((Composite)wCustomGroup, 131072);
        this.wlClearResultList.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.ClearResultList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlClearResultList);
        FormData fdlClearResultList = new FormData();
        fdlClearResultList.left = new FormAttachment(0, -margin);
        fdlClearResultList.top = new FormAttachment((Control)this.wlUseSubs, 2 * margin);
        fdlClearResultList.right = new FormAttachment(middle, -2 * margin);
        this.wlClearResultList.setLayoutData((Object)fdlClearResultList);
        this.wClearResultList = new Button((Composite)wCustomGroup, 32);
        this.props.setLook((Control)this.wClearResultList);
        this.wClearResultList.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.ClearResultList.Tooltip", (String[])new String[0]));
        FormData fdClearResultList = new FormData();
        fdClearResultList.left = new FormAttachment(middle, -margin);
        fdClearResultList.top = new FormAttachment((Control)this.wlClearResultList, 0, 0x1000000);
        fdClearResultList.right = new FormAttachment(100, 0);
        this.wClearResultList.setLayoutData((Object)fdClearResultList);
        this.wClearResultList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.action.setChanged();
            }
        });
        this.wlAddRowsToResult = new Label((Composite)wCustomGroup, 131072);
        this.wlAddRowsToResult.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.AddRowsToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddRowsToResult);
        FormData fdlAddRowsToResult = new FormData();
        fdlAddRowsToResult.left = new FormAttachment(0, -margin);
        fdlAddRowsToResult.top = new FormAttachment((Control)this.wClearResultList, 2 * margin);
        fdlAddRowsToResult.right = new FormAttachment(middle, -2 * margin);
        this.wlAddRowsToResult.setLayoutData((Object)fdlAddRowsToResult);
        this.wAddRowsToResult = new Button((Composite)wCustomGroup, 32);
        this.props.setLook((Control)this.wAddRowsToResult);
        this.wAddRowsToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.AddRowsToResult.Tooltip", (String[])new String[0]));
        FormData fdAddRowsToResult = new FormData();
        fdAddRowsToResult.left = new FormAttachment(middle, -margin);
        fdAddRowsToResult.top = new FormAttachment((Control)this.wlAddRowsToResult, 0, 0x1000000);
        fdAddRowsToResult.right = new FormAttachment(100, 0);
        this.wAddRowsToResult.setLayoutData((Object)fdAddRowsToResult);
        this.wAddRowsToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForSqlDialog.this.action.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)wCustomGroup, 0);
        this.props.setLook((Control)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(100, 0);
        fdlPosition.bottom = new FormAttachment(100, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        this.wlSql = new Label((Composite)wCustomGroup, 0);
        this.wlSql.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Script.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment((Control)this.wAddRowsToResult, margin);
        this.wlSql.setLayoutData((Object)fdlSql);
        this.wbSqlTable = new Button((Composite)wCustomGroup, 0x1000008);
        this.props.setLook((Control)this.wbSqlTable);
        this.wbSqlTable.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.GetSQLAndSelectStatement", (String[])new String[0]));
        FormData fdbSqlTable = new FormData();
        fdbSqlTable.right = new FormAttachment(100, 0);
        fdbSqlTable.top = new FormAttachment((Control)this.wAddRowsToResult, margin);
        this.wbSqlTable.setLayoutData((Object)fdbSqlTable);
        this.wbSqlTable.addListener(13, e -> this.getSql());
        this.wSql = new StyledTextComp((IVariables)this.action, (Composite)wCustomGroup, 19202);
        this.props.setLook((Control)this.wSql, 1);
        this.wSql.addModifyListener(lsMod);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)this.wbSqlTable, margin);
        fdSql.right = new FormAttachment(100, -10);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addModifyListener(arg0 -> this.setPosition());
        this.wSql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ActionWaitForSqlDialog.this.setPosition();
            }
        });
        this.wSql.addModifyListener(lsMod);
        FormData fdCustomGroup = new FormData();
        fdCustomGroup.left = new FormAttachment(0, margin);
        fdCustomGroup.top = new FormAttachment((Control)wSuccessGroup, margin);
        fdCustomGroup.right = new FormAttachment(100, -margin);
        fdCustomGroup.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wCustomGroup.setLayoutData((Object)fdCustomGroup);
        this.getData();
        this.setCustomerSql();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSql() {
        DatabaseMeta inf = this.getWorkflowMeta().findDatabase(this.wConnection.getText());
        if (inf != null) {
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, inf, this.getWorkflowMeta().getDatabases());
            if (!std.open()) return;
            String sql = "SELECT *" + Const.CR + "FROM " + inf.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
            this.wSql.setText(sql);
            MessageBox yn = new MessageBox(this.shell, 452);
            yn.setMessage(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.IncludeFieldNamesInSQL", (String[])new String[0]));
            yn.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.DialogCaptionQuestion", (String[])new String[0]));
            int id = yn.open();
            switch (id) {
                case 256: {
                    return;
                }
                case 128: {
                    this.wSql.setText(sql);
                    return;
                }
                case 64: {
                    Database db = new Database(loggingObject, this.variables, inf);
                    try {
                        db.connect();
                        IRowMeta fields = db.getQueryFields(sql, false);
                        if (fields != null) {
                            sql = "SELECT" + Const.CR;
                            for (int i = 0; i < fields.size(); ++i) {
                                IValueMeta field = fields.getValueMeta(i);
                                sql = i == 0 ? sql + "  " : sql + ", ";
                                sql = sql + inf.quoteField(field.getName()) + Const.CR;
                            }
                            sql = sql + "FROM " + inf.getQuotedSchemaTableCombination(this.variables, std.getSchemaName(), std.getTableName()) + Const.CR;
                            this.wSql.setText(sql);
                            return;
                        } else {
                            MessageBox mb = new MessageBox(this.shell, 33);
                            mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.ERROR_CouldNotRetrieveFields", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"ActionWaitForSQL.PerhapsNoPermissions", (String[])new String[0]));
                            mb.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.DialogCaptionError2", (String[])new String[0]));
                            mb.open();
                        }
                        return;
                    }
                    catch (HopException e) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.DialogCaptionError3", (String[])new String[0]));
                        mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.AnErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                        mb.open();
                        return;
                    }
                    finally {
                        db.disconnect();
                    }
                }
            }
            return;
        }
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.ConnectionNoLongerAvailable", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.DialogCaptionError4", (String[])new String[0]));
        mb.open();
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    private void setCustomerSql() {
        this.wlClearResultList.setEnabled(this.wCustomSql.getSelection());
        this.wClearResultList.setEnabled(this.wCustomSql.getSelection());
        this.wlSql.setEnabled(this.wCustomSql.getSelection());
        this.wSql.setEnabled(this.wCustomSql.getSelection());
        this.wlAddRowsToResult.setEnabled(this.wCustomSql.getSelection());
        this.wAddRowsToResult.setEnabled(this.wCustomSql.getSelection());
        this.wlUseSubs.setEnabled(this.wCustomSql.getSelection());
        this.wbSqlTable.setEnabled(this.wCustomSql.getSelection());
        this.wUseSubs.setEnabled(this.wCustomSql.getSelection());
        this.wbTable.setEnabled(!this.wCustomSql.getSelection());
        this.wTablename.setEnabled(!this.wCustomSql.getSelection());
        this.wlTablename.setEnabled(!this.wCustomSql.getSelection());
        this.wlSchemaname.setEnabled(!this.wCustomSql.getSelection());
        this.wSchemaname.setEnabled(!this.wCustomSql.getSelection());
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        if (this.action.getDatabase() != null) {
            this.wConnection.setText(this.action.getDatabase().getName());
        }
        this.wSchemaname.setText(Const.nullToEmpty((String)this.action.schemaName));
        this.wTablename.setText(Const.nullToEmpty((String)this.action.tableName));
        this.wSuccessCondition.setText(ActionWaitForSql.getSuccessConditionDesc(this.action.successCondition));
        this.wRowsCountValue.setText(Const.NVL((String)this.action.rowsCountValue, (String)"0"));
        this.wCustomSql.setSelection(this.action.isCustomSql);
        this.wUseSubs.setSelection(this.action.isUseVars);
        this.wAddRowsToResult.setSelection(this.action.isAddRowsResult);
        this.wClearResultList.setSelection(this.action.isClearResultList);
        this.wSql.setText(Const.nullToEmpty((String)this.action.customSql));
        this.wMaximumTimeout.setText(Const.NVL((String)this.action.getMaximumTimeout(), (String)""));
        this.wCheckCycleTime.setText(Const.NVL((String)this.action.getCheckCycleTime(), (String)""));
        this.wSuccessOnTimeout.setSelection(this.action.isSuccessOnTimeout());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage("Please give this action a name.");
            mb.setText("Enter the name of the action");
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setDatabase(this.getWorkflowMeta().findDatabase(this.wConnection.getText()));
        this.action.schemaName = this.wSchemaname.getText();
        this.action.tableName = this.wTablename.getText();
        this.action.successCondition = ActionWaitForSql.getSuccessConditionByDesc(this.wSuccessCondition.getText());
        this.action.rowsCountValue = this.wRowsCountValue.getText();
        this.action.isCustomSql = this.wCustomSql.getSelection();
        this.action.isUseVars = this.wUseSubs.getSelection();
        this.action.isAddRowsResult = this.wAddRowsToResult.getSelection();
        this.action.isClearResultList = this.wClearResultList.getSelection();
        this.action.customSql = this.wSql.getText();
        this.action.setMaximumTimeout(this.wMaximumTimeout.getText());
        this.action.setCheckCycleTime(this.wCheckCycleTime.getText());
        this.action.setSuccessOnTimeout(this.wSuccessOnTimeout.getSelection());
        this.dispose();
    }

    private void getTableName() {
        String databaseName = this.wConnection.getText();
        if (StringUtils.isNotEmpty((String)databaseName)) {
            DatabaseMeta databaseMeta = this.getWorkflowMeta().findDatabase(databaseName);
            if (databaseMeta != null) {
                DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.getWorkflowMeta().getDatabases());
                std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablename.getText());
                if (std.open()) {
                    this.wTablename.setText(Const.NVL((String)std.getTableName(), (String)""));
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.ConnectionError2.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }
}

