/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.dialog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.IExecutionConfiguration;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.ui.core.dialog.ConfigurationDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.shared.AuditManagerGuiUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class PipelineExecutionConfigurationDialog
extends ConfigurationDialog {
    private static final Class<?> PKG = PipelineExecutionConfigurationDialog.class;
    public static final String AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS = "last-pipeline-run-configurations";
    public static final String MAP_TYPE_PIPELINE_RUN_CONFIG_USAGE = "pipeline-run-configuration-usage";
    private MetaSelectionLine<PipelineRunConfiguration> wRunConfiguration;

    public PipelineExecutionConfigurationDialog(Shell parent, PipelineExecutionConfiguration configuration, PipelineMeta pipelineMeta) {
        super(parent, (IExecutionConfiguration)configuration, (AbstractMeta)pipelineMeta);
    }

    protected void serverOptionsComposite(Class<?> PKG, String prefix) {
    }

    @Override
    protected void optionsSectionControls() {
        this.wlLogLevel = new Label((Composite)this.gDetails, 0);
        this.props.setLook((Control)this.wlLogLevel);
        this.wlLogLevel.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.LogLevel.Label", (String[])new String[0]));
        this.wlLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        FormData fdlLogLevel = new FormData();
        fdlLogLevel.top = new FormAttachment(0, 0);
        fdlLogLevel.left = new FormAttachment(0, 0);
        this.wlLogLevel.setLayoutData((Object)fdlLogLevel);
        this.wLogLevel = new CCombo((Composite)this.gDetails, 2056);
        this.wLogLevel.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.LogLevel.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLogLevel);
        FormData fdLogLevel = new FormData();
        fdLogLevel.top = new FormAttachment((Control)this.wlLogLevel, -2, 128);
        fdLogLevel.right = new FormAttachment(100, 0);
        fdLogLevel.left = new FormAttachment((Control)this.wlLogLevel, 6);
        this.wLogLevel.setLayoutData((Object)fdLogLevel);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        this.wClearLog = new Button((Composite)this.gDetails, 32);
        this.wClearLog.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.ClearLog.Label", (String[])new String[0]));
        this.wClearLog.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.ClearLog.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wClearLog);
        FormData fdClearLog = new FormData();
        fdClearLog.top = new FormAttachment((Control)this.wLogLevel, 10);
        fdClearLog.left = new FormAttachment(0, 0);
        this.wClearLog.setLayoutData((Object)fdClearLog);
    }

    public boolean open() {
        String shellTitle = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.Shell.Title", (String[])new String[0]);
        this.mainLayout(shellTitle, GuiResource.getInstance().getImagePipeline());
        String alwaysShowOptionLabel = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.AlwaysOption.Value", (String[])new String[0]);
        String alwaysShowOptionTooltip = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.alwaysShowOption", (String[])new String[0]);
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(HopGui.class, (String)"HopGui.PipelineExecutionConfigurationDialog.Help", (String[])new String[0]));
        String docTitle = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.docTitle", (String[])new String[0]);
        String docHeader = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.docHeader", (String[])new String[0]);
        this.buttonsSectionLayout(alwaysShowOptionLabel, alwaysShowOptionTooltip, docTitle, docUrl, docHeader);
        this.addRunConfigurationSectionLayout();
        this.optionsSectionLayout(PKG, "PipelineExecutionConfigurationDialog");
        this.parametersSectionLayout(PKG, "PipelineExecutionConfigurationDialog");
        this.getData();
        this.openDialog();
        return this.retval;
    }

    private void addRunConfigurationSectionLayout() {
        String runConfigLabel = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.PipelineRunConfiguration.Label", (String[])new String[0]);
        String runConfigTooltip = BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.PipelineRunConfiguration.Tooltip", (String[])new String[0]);
        this.wRunConfiguration = new MetaSelectionLine<PipelineRunConfiguration>(this.hopGui.getVariables(), (IHopMetadataProvider)this.hopGui.getMetadataProvider(), PipelineRunConfiguration.class, (Composite)this.shell, 2048, runConfigLabel, runConfigTooltip, true);
        this.wRunConfigurationControl = this.wRunConfiguration;
        this.props.setLook((Control)this.wRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.right = new FormAttachment(100, 0);
        fdRunConfiguration.top = new FormAttachment(0, this.props.getMargin());
        fdRunConfiguration.left = new FormAttachment(0, 0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
    }

    private void getVariablesData() {
        this.wVariables.clearAll(false);
        ArrayList variableNames = new ArrayList(this.configuration.getVariablesMap().keySet());
        Collections.sort(variableNames);
        for (int i = 0; i < variableNames.size(); ++i) {
            String variableName = (String)variableNames.get(i);
            String variableValue = (String)this.configuration.getVariablesMap().get(variableName);
            if (Const.indexOfString((String)variableName, (String[])this.abstractMeta.listParameters()) >= 0) continue;
            TableItem tableItem = new TableItem(this.wVariables.table, 0);
            tableItem.setText(1, variableName);
            tableItem.setText(2, Const.NVL((String)variableValue, (String)""));
        }
        this.wVariables.removeEmptyRows();
        this.wVariables.setRowNums();
        this.wVariables.optWidth(true);
    }

    public void getData() {
        this.wClearLog.setSelection(this.configuration.isClearingLog());
        try {
            this.wRunConfiguration.fillItems();
            if (Const.indexOfString((String)this.configuration.getRunConfiguration(), (String[])this.wRunConfiguration.getItems()) < 0) {
                this.getConfiguration().setRunConfiguration(null);
            }
        }
        catch (Exception e) {
            this.hopGui.getLog().logError("Unable to obtain a list of pipeline run configurations", (Throwable)e);
        }
        Map<String, String> pipelineUsageMap = null;
        String lastGlobalRunConfig = AuditManagerGuiUtil.getLastUsedValue(AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS);
        String lastPipelineRunConfig = null;
        if (StringUtils.isNotEmpty((String)this.abstractMeta.getName())) {
            pipelineUsageMap = AuditManagerGuiUtil.getUsageMap(MAP_TYPE_PIPELINE_RUN_CONFIG_USAGE);
            lastPipelineRunConfig = pipelineUsageMap.get(this.abstractMeta.getName());
        }
        this.wRunConfiguration.setText(Const.NVL(lastPipelineRunConfig, (String)""));
        if (StringUtils.isNotEmpty(lastPipelineRunConfig) && StringUtils.isNotEmpty((String)lastGlobalRunConfig) && !lastPipelineRunConfig.equals(lastGlobalRunConfig)) {
            this.wRunConfiguration.getLabelWidget().setBackground(GuiResource.getInstance().getColorLightBlue());
            this.wRunConfiguration.getLabelWidget().setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.VerifyRunConfigurationName.Warning", (String[])new String[0]));
            this.wRunConfiguration.getComboWidget().setBackground(GuiResource.getInstance().getColorLightBlue());
            this.wRunConfiguration.getComboWidget().setToolTipText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.VerifyRunConfigurationName.Warning", (String[])new String[0]));
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)this.hopGui.getVariables(), (String)HopExtensionPoint.HopGuiRunConfiguration.id, this.wRunConfiguration);
        }
        catch (HopException e) {
            this.hopGui.getLog().logError("Error calling extension point with ID '" + HopExtensionPoint.HopGuiRunConfiguration.id + "'", (Throwable)e);
        }
        if (StringUtil.isEmpty((String)this.wRunConfiguration.getText())) {
            if (StringUtils.isNotEmpty((String)this.getConfiguration().getRunConfiguration())) {
                this.wRunConfiguration.setText(this.getConfiguration().getRunConfiguration());
            } else if (this.wRunConfiguration.getItemCount() == 1) {
                this.wRunConfiguration.select(0);
            }
        }
        if (pipelineUsageMap != null && pipelineUsageMap.containsKey("LOG_LEVEL")) {
            this.wLogLevel.select(Integer.parseInt(pipelineUsageMap.get("LOG_LEVEL")));
        } else {
            this.wLogLevel.select(this.configuration.getLogLevel().getLevel());
        }
        this.getParamsData();
        this.getVariablesData();
    }

    @Override
    public boolean getInfo() {
        try {
            String runConfigurationName;
            IHopMetadataSerializer serializer = this.hopGui.getMetadataProvider().getSerializer(PipelineRunConfiguration.class);
            if (serializer.listObjectNames().isEmpty()) {
                String name = PipelineExecutionConfigurationDialog.createLocalPipelineConfiguration(this.shell, (IHopMetadataSerializer<PipelineRunConfiguration>)serializer);
                this.wRunConfiguration.setText(name);
            }
            if (StringUtils.isEmpty((String)(runConfigurationName = this.wRunConfiguration.getText()))) {
                MessageBox box = new MessageBox(this.shell, 34);
                box.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.NoRunConfigurationSpecified.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.NoRunConfigurationSpecified.Message", (String[])new String[0]));
                box.open();
                return false;
            }
            if (!serializer.exists(this.hopGui.getVariables().resolve(runConfigurationName))) {
                MessageBox box = new MessageBox(this.shell, 33);
                box.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.RunConfigurationDoesNotExist.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.RunConfigurationDoesNotExist.Message", (String[])new String[]{runConfigurationName}));
                box.open();
                return false;
            }
            this.getConfiguration().setRunConfiguration(runConfigurationName);
            AuditManagerGuiUtil.addLastUsedValue(AUDIT_LIST_TYPE_LAST_USED_RUN_CONFIGURATIONS, runConfigurationName);
            if (StringUtils.isNotEmpty((String)this.abstractMeta.getName())) {
                Map<String, String> usageMap = AuditManagerGuiUtil.getUsageMap(MAP_TYPE_PIPELINE_RUN_CONFIG_USAGE);
                usageMap.put(this.abstractMeta.getName(), runConfigurationName);
                usageMap.put("LOG_LEVEL", String.valueOf(this.wLogLevel.getSelectionIndex()));
                AuditManagerGuiUtil.saveUsageMap(MAP_TYPE_PIPELINE_RUN_CONFIG_USAGE, usageMap);
            }
            this.configuration.setClearingLog(this.wClearLog.getSelection());
            this.configuration.setLogLevel(LogLevel.values()[this.wLogLevel.getSelectionIndex()]);
            this.getInfoParameters();
            this.getInfoVariables();
            return true;
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineDialog.RunConfigurationSettingsDialog.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineDialog.RunConfigurationSettingsDialog.Error.Message", (String[])new String[0]), e);
            return false;
        }
    }

    public static final String createLocalPipelineConfiguration(Shell shell, IHopMetadataSerializer<PipelineRunConfiguration> prcSerializer) {
        try {
            MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 196);
            box.setText(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.NoRunConfigurationDefined.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.NoRunConfigurationDefined.Message", (String[])new String[0]));
            int answer = box.open();
            if ((answer & 0x40) != 0) {
                LocalPipelineRunConfiguration localPipelineRunConfiguration = new LocalPipelineRunConfiguration();
                localPipelineRunConfiguration.setEnginePluginId("Local");
                PipelineRunConfiguration local = new PipelineRunConfiguration("local", "", BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.LocalRunConfiguration.Description", (String[])new String[0]), new ArrayList(), (IPipelineEngineRunConfiguration)localPipelineRunConfiguration, null);
                prcSerializer.save((IHopMetadata)local);
                return local.getName();
            }
        }
        catch (Exception e) {
            new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.ErrorSavingRunConfiguration.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineExecutionConfigurationDialog.ErrorSavingRunConfiguration.Message", (String[])new String[0]), e);
        }
        return null;
    }

    public PipelineExecutionConfiguration getConfiguration() {
        return (PipelineExecutionConfiguration)this.configuration;
    }
}

