/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdCoder;

public class MetadataCoder
extends AtomicCoder<MatchResult.Metadata> {
    private static final MetadataCoder INSTANCE = new MetadataCoder();
    private static final ResourceIdCoder RESOURCE_ID_CODER = ResourceIdCoder.of();
    private static final VarIntCoder INT_CODER = VarIntCoder.of();
    private static final VarLongCoder LONG_CODER = VarLongCoder.of();

    private MetadataCoder() {
    }

    public static MetadataCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(MatchResult.Metadata value, OutputStream os) throws IOException {
        RESOURCE_ID_CODER.encode(value.resourceId(), os);
        INT_CODER.encode(value.isReadSeekEfficient() ? 1 : 0, os);
        LONG_CODER.encode(value.sizeBytes(), os);
    }

    @Override
    public MatchResult.Metadata decode(InputStream is) throws IOException {
        return this.decodeBuilder(is).build();
    }

    MatchResult.Metadata.Builder decodeBuilder(InputStream is) throws IOException {
        ResourceId resourceId = RESOURCE_ID_CODER.decode(is);
        boolean isReadSeekEfficient = INT_CODER.decode(is) == 1;
        long sizeBytes = LONG_CODER.decode(is);
        return MatchResult.Metadata.builder().setResourceId(resourceId).setIsReadSeekEfficient(isReadSeekEfficient).setSizeBytes(sizeBytes);
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }
}

