/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class EnumerationType
implements Schema.LogicalType<Value, Integer> {
    public static final String IDENTIFIER = "Enum";
    final BiMap<String, Integer> enumValues = HashBiMap.create();
    final List<String> values;

    private EnumerationType(Map<String, Integer> enumValues) {
        this.enumValues.putAll(enumValues);
        this.values = enumValues.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static EnumerationType create(Map<String, Integer> enumValues) {
        return new EnumerationType(enumValues);
    }

    public static EnumerationType create(List<String> enumValues) {
        return new EnumerationType(IntStream.range(0, enumValues.size()).boxed().collect(Collectors.toMap(i -> (String)enumValues.get((int)i), i -> i)));
    }

    public static EnumerationType create(String ... enumValues) {
        return EnumerationType.create(Arrays.asList(enumValues));
    }

    public Value valueOf(String stringValue) {
        return new Value((Integer)this.enumValues.get((Object)stringValue));
    }

    public Value valueOf(int value) {
        return new Value(value);
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Schema.FieldType getArgumentType() {
        return Schema.FieldType.map(Schema.FieldType.STRING, Schema.FieldType.INT32);
    }

    @Override
    public Map<String, Integer> getArgument() {
        return this.enumValues;
    }

    @Override
    public Schema.FieldType getBaseType() {
        return Schema.FieldType.INT32;
    }

    @Override
    public Integer toBaseType(Value input) {
        return input.getValue();
    }

    @Override
    public Value toInputType(Integer base) {
        return this.valueOf(base);
    }

    public Map<String, Integer> getValuesMap() {
        return this.enumValues;
    }

    public List<String> getValues() {
        return this.values;
    }

    public String toString(Value value) {
        return (String)this.enumValues.inverse().get((Object)value.getValue());
    }

    public String toString() {
        return "Enumeration: " + this.enumValues;
    }

    public static class Value
    implements Serializable {
        private final int value;

        public Value(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value enumValue = (Value)o;
            return this.value == enumValue.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "enum value: " + this.value;
        }
    }
}

