/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MapElements<InputT, OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private final transient @Nullable TypeDescriptor<InputT> inputType;
    private final transient @Nullable TypeDescriptor<OutputT> outputType;
    private final transient @Nullable Object originalFnForDisplayData;
    private final @Nullable Contextful<Contextful.Fn<InputT, OutputT>> fn;

    private MapElements(@Nullable Contextful<Contextful.Fn<InputT, OutputT>> fn, @Nullable Object originalFnForDisplayData, @Nullable TypeDescriptor<InputT> inputType, TypeDescriptor<OutputT> outputType) {
        this.fn = fn;
        this.originalFnForDisplayData = originalFnForDisplayData;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public static <InputT, OutputT> MapElements<InputT, OutputT> via(InferableFunction<InputT, OutputT> fn) {
        return new MapElements<InputT, OutputT>(Contextful.fn(fn), fn, fn.getInputTypeDescriptor(), fn.getOutputTypeDescriptor());
    }

    public static <InputT, OutputT> MapElements<InputT, OutputT> via(SimpleFunction<InputT, OutputT> fn) {
        return MapElements.via(fn);
    }

    public static <OutputT> MapElements<?, OutputT> into(TypeDescriptor<OutputT> outputType) {
        return new MapElements(null, null, null, outputType);
    }

    public <NewInputT> MapElements<NewInputT, OutputT> via(ProcessFunction<NewInputT, OutputT> fn) {
        return new MapElements<InputT, OutputT>(Contextful.fn(fn), fn, TypeDescriptors.inputOf(fn), this.outputType);
    }

    public <NewInputT> MapElements<NewInputT, OutputT> via(SerializableFunction<NewInputT, OutputT> fn) {
        return this.via((ProcessFunction<NewInputT, OutputT>)fn);
    }

    @Experimental(value=Experimental.Kind.CONTEXTFUL)
    public <NewInputT> MapElements<NewInputT, OutputT> via(Contextful<Contextful.Fn<NewInputT, OutputT>> fn) {
        return new MapElements<InputT, OutputT>(fn, fn.getClosure(), TypeDescriptors.inputOf(fn.getClosure()), this.outputType);
    }

    @Override
    public PCollection<OutputT> expand(PCollection<? extends InputT> input) {
        Preconditions.checkNotNull(this.fn, (Object)"Must specify a function on MapElements using .via()");
        return (PCollection)input.apply("Map", ParDo.of(new DoFn<InputT, OutputT>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element InputT element, DoFn.OutputReceiver<OutputT> receiver, DoFn.ProcessContext c) throws Exception {
                receiver.output(((Contextful.Fn)MapElements.this.fn.getClosure()).apply(element, Contextful.Fn.Context.wrapProcessContext(c)));
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(MapElements.this);
            }

            @Override
            public TypeDescriptor<InputT> getInputTypeDescriptor() {
                return MapElements.this.inputType;
            }

            @Override
            public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState((MapElements.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)MapElements.class.getSimpleName());
                return MapElements.this.outputType;
            }
        }).withSideInputs(this.fn.getRequirements().getSideInputs()));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("class", this.originalFnForDisplayData.getClass()));
        if (this.originalFnForDisplayData instanceof HasDisplayData) {
            builder.include("fn", (HasDisplayData)this.originalFnForDisplayData);
        }
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <NewFailureT> MapWithFailures<InputT, OutputT, NewFailureT> exceptionsInto(TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new MapWithFailures<InputT, OutputT, NewFailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, null, failureTypeDescriptor);
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public <FailureT> MapWithFailures<InputT, OutputT, FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
        return new MapWithFailures<InputT, OutputT, FailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
    public static class MapWithFailures<InputT, OutputT, FailureT>
    extends PTransform<PCollection<InputT>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        private final transient TypeDescriptor<InputT> inputType;
        private final transient TypeDescriptor<OutputT> outputType;
        private final transient @Nullable TypeDescriptor<FailureT> failureType;
        private final transient Object originalFnForDisplayData;
        private final Contextful<Contextful.Fn<InputT, OutputT>> fn;
        private final @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler;

        MapWithFailures(Contextful<Contextful.Fn<InputT, OutputT>> fn, Object originalFnForDisplayData, TypeDescriptor<InputT> inputType, TypeDescriptor<OutputT> outputType, @Nullable ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler, @Nullable TypeDescriptor<FailureT> failureType) {
            this.fn = fn;
            this.originalFnForDisplayData = originalFnForDisplayData;
            this.inputType = inputType;
            this.outputType = outputType;
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public MapWithFailures<InputT, OutputT, FailureT> exceptionsVia(ProcessFunction<WithFailures.ExceptionElement<InputT>, FailureT> exceptionHandler) {
            return new MapWithFailures<InputT, OutputT, FailureT>(this.fn, this.originalFnForDisplayData, this.inputType, this.outputType, exceptionHandler, this.failureType);
        }

        @Override
        public WithFailures.Result<PCollection<OutputT>, FailureT> expand(PCollection<InputT> input) {
            Preconditions.checkArgument((this.exceptionHandler != null ? 1 : 0) != 0, (Object)".exceptionsVia() is required");
            MapFn doFn = new MapFn();
            PCollectionTuple tuple = (PCollectionTuple)input.apply(MapWithFailures.class.getSimpleName(), ParDo.of(doFn).withOutputTags(doFn.outputTag, TupleTagList.of(doFn.failureTag)).withSideInputs(this.fn.getRequirements().getSideInputs()));
            return WithFailures.Result.of(tuple, doFn.outputTag, doFn.failureTag);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("class", this.originalFnForDisplayData.getClass()));
            if (this.originalFnForDisplayData instanceof HasDisplayData) {
                builder.include("fn", (HasDisplayData)this.originalFnForDisplayData);
            }
            builder.add(DisplayData.item("exceptionHandler.class", this.exceptionHandler.getClass()));
            if (this.exceptionHandler instanceof HasDisplayData) {
                builder.include("exceptionHandler", (HasDisplayData)((Object)this.exceptionHandler));
            }
        }

        private class MapFn
        extends DoFn<InputT, OutputT> {
            final TupleTag<OutputT> outputTag = new TupleTag<OutputT>(){};
            final TupleTag<FailureT> failureTag = new FailureTag();

            private MapFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element InputT element, DoFn.MultiOutputReceiver r, DoFn.ProcessContext c) throws Exception {
                boolean exceptionWasThrown = false;
                Object result = null;
                try {
                    result = ((Contextful.Fn)MapWithFailures.this.fn.getClosure()).apply(c.element(), Contextful.Fn.Context.wrapProcessContext(c));
                }
                catch (Exception e) {
                    exceptionWasThrown = true;
                    WithFailures.ExceptionElement exceptionElement = WithFailures.ExceptionElement.of(element, e);
                    r.get(this.failureTag).output(MapWithFailures.this.exceptionHandler.apply(exceptionElement));
                }
                if (!exceptionWasThrown) {
                    r.get(this.outputTag).output(result);
                }
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                builder.delegate(MapWithFailures.this);
            }

            @Override
            public TypeDescriptor<InputT> getInputTypeDescriptor() {
                return MapWithFailures.this.inputType;
            }

            @Override
            public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
                Preconditions.checkState((MapWithFailures.this.outputType != null ? 1 : 0) != 0, (String)"%s output type descriptor was null; this probably means that getOutputTypeDescriptor() was called after serialization/deserialization, but it is only available prior to serialization, for constructing a pipeline and inferring coders", (Object)MapWithFailures.class.getSimpleName());
                return MapWithFailures.this.outputType;
            }
        }

        private class FailureTag
        extends TupleTag<FailureT> {
            private FailureTag() {
            }

            @Override
            public TypeDescriptor<FailureT> getTypeDescriptor() {
                return MapWithFailures.this.failureType;
            }
        }
    }
}

