/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Internal
public class Preconditions {
    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return reference;
    }

    @EnsuresNonNull(value={"reference"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])errorMessageArgs));
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, char p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, int p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, long p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, char p1, char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, char p1, int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, char p1, long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, char p1, @Nullable Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{Character.valueOf(p1), p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, int p1, char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, int p1, int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, int p1, long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, int p1, @Nullable Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, long p1, char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, long p1, int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, long p1, long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, long p1, @Nullable Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, char p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, Character.valueOf(p2)}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, int p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, long p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2, p3}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkArgumentNotNull(@Nullable T obj, @Nullable String errorMessageTemplate, @Nullable Object p1, @Nullable Object p2, @Nullable Object p3, @Nullable Object p4) {
        if (obj == null) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)errorMessageTemplate, (Object[])new Object[]{p1, p2, p3, p4}));
        }
        return obj;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T reference) {
        if (reference == null) {
            throw new IllegalStateException();
        }
        return reference;
    }

    @EnsuresNonNull(value={"#1"})
    @CanIgnoreReturnValue
    public static <T> T checkStateNotNull(@Nullable T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
        return reference;
    }
}

