/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class PipelineUnitTestSetLocationDialog
extends Dialog {
    private static final Class<?> PKG = PipelineUnitTestSetLocationDialog.class;
    private final PipelineUnitTestSetLocation location;
    private final List<DataSet> dataSets;
    private final Map<String, IRowMeta> transformFieldsMap;
    private final String[] transformNames;
    private final String[] datasetNames;
    private final IVariables variables;
    private final IHopMetadataProvider metadataProvider;
    private Shell shell;
    private Combo wTransformName;
    private MetaSelectionLine<DataSet> wDataset;
    private TableView wFieldMappings;
    private TableView wFieldOrder;
    private final PropsUi props;
    private boolean ok;

    public PipelineUnitTestSetLocationDialog(Shell parent, IVariables variables, IHopMetadataProvider metadataProvider, PipelineUnitTestSetLocation location, List<DataSet> dataSets, Map<String, IRowMeta> transformFieldsMap) {
        super(parent, 0);
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        this.location = location;
        this.dataSets = dataSets;
        this.transformFieldsMap = transformFieldsMap;
        this.props = PropsUi.getInstance();
        this.ok = false;
        this.transformNames = transformFieldsMap.keySet().toArray(new String[0]);
        this.datasetNames = new String[dataSets.size()];
        for (int i = 0; i < this.datasetNames.length; ++i) {
            this.datasetNames[i] = dataSets.get(i).getName();
        }
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageTable());
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlTransformName);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.TransformName.Label", (String[])new String[0]));
        FormData fdlTransformName = new FormData();
        fdlTransformName.top = new FormAttachment(0, 0);
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Combo((Composite)this.shell, 18436);
        this.wTransformName.setItems(this.transformNames);
        FormData fdTransformName = new FormData();
        fdTransformName.top = new FormAttachment(0, 0);
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label lastControl = this.wTransformName;
        this.wDataset = new MetaSelectionLine(this.variables, this.metadataProvider, DataSet.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.DatasetName.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.DatasetName.Label", (String[])new String[0]));
        FormData fdDatasetName = new FormData();
        fdDatasetName.top = new FormAttachment((Control)lastControl, margin);
        fdDatasetName.left = new FormAttachment(0, 0);
        fdDatasetName.right = new FormAttachment(100, 0);
        this.wDataset.setLayoutData((Object)fdDatasetName);
        lastControl = this.wDataset;
        Label wlFieldMapping = new Label((Composite)this.shell, 16384);
        wlFieldMapping.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.FieldMapping.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFieldMapping);
        FormData fdlFieldMapping = new FormData();
        fdlFieldMapping.left = new FormAttachment(0, 0);
        fdlFieldMapping.right = new FormAttachment(60, -margin);
        fdlFieldMapping.top = new FormAttachment(lastControl, margin * 2);
        wlFieldMapping.setLayoutData((Object)fdlFieldMapping);
        Label wlFieldOrder = new Label((Composite)this.shell, 16384);
        wlFieldOrder.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.FieldOrder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFieldOrder);
        FormData fdlFieldOrder = new FormData();
        fdlFieldOrder.left = new FormAttachment(60, margin);
        fdlFieldOrder.right = new FormAttachment(100, 0);
        fdlFieldOrder.top = new FormAttachment(lastControl, margin * 2);
        wlFieldOrder.setLayoutData((Object)fdlFieldOrder);
        lastControl = wlFieldMapping;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wMapFields = new Button((Composite)this.shell, 8);
        wMapFields.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.MapFields.Button", (String[])new String[0]));
        wMapFields.addListener(13, e -> this.getFieldMappings());
        Button wGetSortFields = new Button((Composite)this.shell, 8);
        wGetSortFields.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.GetSortFields.Button", (String[])new String[0]));
        wGetSortFields.addListener(13, e -> this.getSortFields());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wMapFields, wGetSortFields, wCancel}, (int)margin, null);
        ColumnInfo[] fieldMappingColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.ColumnInfo.TransformField", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.ColumnInfo.DatasetField", (String[])new String[0]), 1, false)};
        this.wFieldMappings = new TableView((IVariables)new Variables(), (Composite)this.shell, 68354, fieldMappingColumns, this.location.getFieldMappings().size(), null, this.props);
        FormData fdFieldMapping = new FormData();
        fdFieldMapping.left = new FormAttachment(0, 0);
        fdFieldMapping.top = new FormAttachment((Control)lastControl, margin);
        fdFieldMapping.right = new FormAttachment(60, -margin);
        fdFieldMapping.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFieldMappings.setLayoutData((Object)fdFieldMapping);
        ColumnInfo[] fieldOrderColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestSetLocationDialog.ColumnInfo.DatasetField", (String[])new String[0]), 1, false)};
        this.wFieldOrder = new TableView((IVariables)new Variables(), (Composite)this.shell, 68354, fieldOrderColumns, this.location.getFieldOrder().size(), null, this.props);
        FormData fdFieldOrder = new FormData();
        fdFieldOrder.left = new FormAttachment(60, margin);
        fdFieldOrder.top = new FormAttachment((Control)lastControl, margin);
        fdFieldOrder.right = new FormAttachment(100, 0);
        fdFieldOrder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFieldOrder.setLayoutData((Object)fdFieldOrder);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.ok;
    }

    protected void getFieldMappings() {
        try {
            PipelineUnitTestSetLocation loc = new PipelineUnitTestSetLocation();
            this.getInfo(loc);
            String transformName = this.wTransformName.getText();
            String datasetName = this.wDataset.getText();
            if (StringUtils.isEmpty((String)transformName) || StringUtils.isEmpty((String)datasetName)) {
                throw new HopException("Please select a transform and a data set to map fields between");
            }
            IRowMeta transformRowMeta = this.transformFieldsMap.get(transformName);
            if (transformRowMeta == null) {
                throw new HopException("Unable to find fields for transform " + transformName);
            }
            String[] transformFieldNames = transformRowMeta.getFieldNames();
            DataSet dataSet = this.findDataSet(datasetName);
            IRowMeta setRowMeta = dataSet.getSetRowMeta();
            String[] setFieldNames = setRowMeta.getFieldNames();
            ArrayList<SourceToTargetMapping> currentMappings = new ArrayList<SourceToTargetMapping>();
            for (PipelineUnitTestFieldMapping mapping : loc.getFieldMappings()) {
                int transformFieldIndex = transformRowMeta.indexOfValue(mapping.getTransformFieldName());
                int setFieldIndex = transformRowMeta.indexOfValue(mapping.getDataSetFieldName());
                if (transformFieldIndex < 0 || setFieldIndex < 0) continue;
                currentMappings.add(new SourceToTargetMapping(transformFieldIndex, setFieldIndex));
            }
            EnterMappingDialog mappingDialog = new EnterMappingDialog(this.shell, transformFieldNames, setFieldNames, currentMappings);
            List newMappings = mappingDialog.open();
            if (newMappings != null) {
                this.wFieldMappings.clearAll();
                for (SourceToTargetMapping sourceToTargetMapping : newMappings) {
                    TableItem item = new TableItem(this.wFieldMappings.table, 0);
                    item.setText(1, transformFieldNames[sourceToTargetMapping.getSourcePosition()]);
                    item.setText(2, setFieldNames[sourceToTargetMapping.getTargetPosition()]);
                }
                this.wFieldMappings.removeEmptyRows();
                this.wFieldMappings.setRowNums();
                this.wFieldMappings.optWidth(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error mapping fields from transform to dataset", e);
        }
    }

    private DataSet findDataSet(String datasetName) throws HopException {
        for (DataSet dataSet : this.dataSets) {
            if (!dataSet.getName().equalsIgnoreCase(datasetName)) continue;
            return dataSet;
        }
        throw new HopException("Unable to find data set with name " + datasetName);
    }

    protected void getSortFields() {
        try {
            String datasetName = this.wDataset.getText();
            if (StringUtils.isEmpty((String)datasetName)) {
                throw new HopException("Please select a data set to get order fields from");
            }
            DataSet dataSet = this.findDataSet(datasetName);
            IRowMeta setRowMeta = dataSet.getSetRowMeta();
            String[] setFieldNames = setRowMeta.getFieldNames();
            this.wFieldOrder.clearAll();
            for (String setFieldName : setFieldNames) {
                TableItem item = new TableItem(this.wFieldOrder.table, 0);
                item.setText(1, setFieldName);
            }
            this.wFieldOrder.removeEmptyRows();
            this.wFieldOrder.setRowNums();
            this.wFieldOrder.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting sort fields", e);
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        int colnr;
        int i;
        this.wTransformName.setText(Const.NVL((String)this.location.getTransformName(), (String)""));
        try {
            this.wDataset.fillItems();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting data sets from the metadata", e);
        }
        this.wDataset.setText(Const.NVL((String)this.location.getDataSetName(), (String)""));
        for (i = 0; i < this.location.getFieldMappings().size(); ++i) {
            PipelineUnitTestFieldMapping fieldMapping = this.location.getFieldMappings().get(i);
            colnr = 1;
            this.wFieldMappings.setText(Const.NVL((String)fieldMapping.getTransformFieldName(), (String)""), colnr++, i);
            this.wFieldMappings.setText(Const.NVL((String)fieldMapping.getDataSetFieldName(), (String)""), colnr++, i);
        }
        this.wFieldMappings.removeEmptyRows();
        this.wFieldMappings.setRowNums();
        this.wFieldMappings.optWidth(true);
        for (i = 0; i < this.location.getFieldOrder().size(); ++i) {
            String field = this.location.getFieldOrder().get(i);
            colnr = 1;
            this.wFieldOrder.setText(Const.NVL((String)field, (String)""), colnr++, i);
        }
        this.wFieldOrder.removeEmptyRows();
        this.wFieldOrder.setRowNums();
        this.wFieldOrder.optWidth(true);
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void getInfo(PipelineUnitTestSetLocation loc) {
        loc.setTransformName(this.wTransformName.getText());
        loc.setDataSetName(this.wDataset.getText());
        loc.getFieldMappings().clear();
        int nrMappings = this.wFieldMappings.nrNonEmpty();
        for (int i = 0; i < nrMappings; ++i) {
            TableItem item = this.wFieldMappings.getNonEmpty(i);
            int colnr = 1;
            String transformFieldName = item.getText(colnr++);
            String dataSetFieldName = item.getText(colnr++);
            loc.getFieldMappings().add(new PipelineUnitTestFieldMapping(transformFieldName, dataSetFieldName));
        }
        loc.getFieldOrder().clear();
        int nrFields = this.wFieldOrder.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFieldOrder.getNonEmpty(i);
            int colnr = 1;
            String fieldname = item.getText(colnr++);
            loc.getFieldOrder().add(fieldname);
        }
    }

    public void ok() {
        this.getInfo(this.location);
        this.ok = true;
        this.dispose();
    }
}

