/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefile;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.deletefile.ActionDeleteFile;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionDeleteFileDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionDeleteFile.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionDeleteFile.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wFilename;
    private Button wAbortExists;
    private ActionDeleteFile action;
    private boolean changed;

    public ActionDeleteFileDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionDeleteFile)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionDeleteFile.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFile.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFile.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFile.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wName, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wName, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wName, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
        Label wlAbortExists = new Label((Composite)this.shell, 131072);
        wlAbortExists.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFile.FailIfExists.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAbortExists);
        FormData fdlAbortExists = new FormData();
        fdlAbortExists.left = new FormAttachment(0, 0);
        fdlAbortExists.top = new FormAttachment((Control)this.wFilename, margin);
        fdlAbortExists.right = new FormAttachment(middle, -margin);
        wlAbortExists.setLayoutData((Object)fdlAbortExists);
        this.wAbortExists = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAbortExists);
        this.wAbortExists.setToolTipText(BaseMessages.getString(PKG, (String)"ActionDeleteFile.FailIfExists.Tooltip", (String[])new String[0]));
        FormData fdAbortExists = new FormData();
        fdAbortExists.left = new FormAttachment(middle, 0);
        fdAbortExists.top = new FormAttachment((Control)wlAbortExists, 0, 0x1000000);
        fdAbortExists.right = new FormAttachment(100, 0);
        this.wAbortExists.setLayoutData((Object)fdAbortExists);
        this.wAbortExists.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionDeleteFileDialog.this.action.setChanged();
            }
        });
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)(2 * margin), (Control)wlAbortExists);
        wCancel.addListener(13, e -> this.cancel());
        wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        if (this.action.getFilename() != null) {
            this.wFilename.setText(this.action.getFilename());
        }
        this.wAbortExists.setSelection(this.action.isFailIfFileNotExists());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setFailIfFileNotExists(this.wAbortExists.getSelection());
        this.dispose();
    }
}

