/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.ScheduledExecutorService;

@InternalApi(value="For internal usage only")
public class RetryingUnaryOperation<RequestT, ResponseT>
extends AbstractRetryingOperation<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService executorService, Metadata metadata, ApiClock clock) {
        super(retryOptions, request, retryableRpc, deadlineGenerator, executorService, metadata, clock);
    }

    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        if (this.value == null) {
            this.completionFuture.setException((Throwable)NO_VALUE_SET_EXCEPTION);
        }
        return true;
    }
}

