/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MemoryGroupByDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MemoryGroupByMeta.class;
    private TableView wGroup;
    private TableView wAgg;
    private Button wAlwaysAddResult;
    private final MemoryGroupByMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private final Map<String, Integer> inputFields;

    public MemoryGroupByDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (MemoryGroupByMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MemoryGroupByDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlAlwaysAddResult = new Label((Composite)this.shell, 131072);
        wlAlwaysAddResult.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.Label", (String[])new String[0]));
        wlAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)wlAlwaysAddResult);
        FormData fdlAlwaysAddResult = new FormData();
        fdlAlwaysAddResult.left = new FormAttachment(0, 0);
        fdlAlwaysAddResult.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlAlwaysAddResult.right = new FormAttachment(middle, -margin);
        wlAlwaysAddResult.setLayoutData((Object)fdlAlwaysAddResult);
        this.wAlwaysAddResult = new Button((Composite)this.shell, 32);
        this.wAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wAlwaysAddResult);
        FormData fdAlwaysAddResult = new FormData();
        fdAlwaysAddResult.left = new FormAttachment(middle, 0);
        fdAlwaysAddResult.top = new FormAttachment((Control)wlAlwaysAddResult, 0, 0x1000000);
        fdAlwaysAddResult.right = new FormAttachment(100, 0);
        this.wAlwaysAddResult.setLayoutData((Object)fdAlwaysAddResult);
        this.wAlwaysAddResult.addSelectionListener((SelectionListener)lsSel);
        Label wlGroup = new Label((Composite)this.shell, 0);
        wlGroup.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Group.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGroup);
        FormData fdlGroup = new FormData();
        fdlGroup.left = new FormAttachment(0, 0);
        fdlGroup.top = new FormAttachment((Control)wlAlwaysAddResult, 2 * margin);
        wlGroup.setLayoutData((Object)fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupField() != null ? this.input.getGroupField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wGroup = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGet = new FormData();
        fdGet.top = new FormAttachment((Control)wlGroup, margin);
        fdGet.right = new FormAttachment(100, 0);
        wGet.setLayoutData((Object)fdGet);
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0, 0);
        fdGroup.top = new FormAttachment((Control)wlGroup, margin);
        fdGroup.right = new FormAttachment((Control)wGet, -margin);
        fdGroup.bottom = new FormAttachment(45, 0);
        this.wGroup.setLayoutData((Object)fdGroup);
        Label wlAgg = new Label((Composite)this.shell, 0);
        wlAgg.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Aggregates.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAgg);
        FormData fdlAgg = new FormData();
        fdlAgg.left = new FormAttachment(0, 0);
        fdlAgg.top = new FormAttachment((Control)this.wGroup, margin);
        wlAgg.setLayoutData((Object)fdlAgg);
        int upInsCols = 4;
        int upInsRows = this.input.getAggregateField() != null ? this.input.getAggregateField().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Name", (String[])new String[0]), 1, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Subject", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Type", (String[])new String[0]), 2, MemoryGroupByMeta.typeGroupLongDesc);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Value", (String[])new String[0]), 1, false);
        this.ciReturn[3].setToolTip(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Value.Tooltip", (String[])new String[0]));
        this.ciReturn[3].setUsingVariables(true);
        this.wAgg = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wGetAgg = new Button((Composite)this.shell, 8);
        wGetAgg.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdGetAgg = new FormData();
        fdGetAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdGetAgg.right = new FormAttachment(100, 0);
        wGetAgg.setLayoutData((Object)fdGetAgg);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdAgg = new FormData();
        fdAgg.left = new FormAttachment(0, 0);
        fdAgg.top = new FormAttachment((Control)wlAgg, margin);
        fdAgg.right = new FormAttachment((Control)wGetAgg, -margin);
        fdAgg.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wAgg.setLayoutData((Object)fdAgg);
        this.wOk.addListener(13, e -> this.ok());
        wGet.addListener(13, e -> this.get());
        wGetAgg.addListener(13, e -> this.getAgg());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.backupChanged);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wAlwaysAddResult.setSelection(this.input.isAlwaysGivingBackOneRow());
        if (this.input.getGroupField() != null) {
            for (i = 0; i < this.input.getGroupField().length; ++i) {
                item = this.wGroup.table.getItem(i);
                if (this.input.getGroupField()[i] == null) continue;
                item.setText(1, this.input.getGroupField()[i]);
            }
        }
        if (this.input.getAggregateField() != null) {
            for (i = 0; i < this.input.getAggregateField().length; ++i) {
                item = this.wAgg.table.getItem(i);
                if (this.input.getAggregateField()[i] != null) {
                    item.setText(1, this.input.getAggregateField()[i]);
                }
                if (this.input.getSubjectField()[i] != null) {
                    item.setText(2, this.input.getSubjectField()[i]);
                }
                item.setText(3, Const.NVL((String)MemoryGroupByMeta.getTypeDescLong(this.input.getAggregateType()[i]), (String)""));
                if (this.input.getValueField()[i] == null) continue;
                item.setText(4, this.input.getValueField()[i]);
            }
        }
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wAgg.setRowNums();
        this.wAgg.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrFields = this.wAgg.nrNonEmpty();
        this.input.setAlwaysGivingBackOneRow(this.wAlwaysAddResult.getSelection());
        this.input.allocate(sizegroup, nrFields);
        for (i = 0; i < sizegroup; ++i) {
            item = this.wGroup.getNonEmpty(i);
            this.input.getGroupField()[i] = item.getText(1);
        }
        for (i = 0; i < nrFields; ++i) {
            item = this.wAgg.getNonEmpty(i);
            this.input.getAggregateField()[i] = item.getText(1);
            this.input.getSubjectField()[i] = item.getText(2);
            this.input.getAggregateType()[i] = MemoryGroupByMeta.getType(item.getText(3));
            this.input.getValueField()[i] = item.getText(4);
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wGroup, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wAgg, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

