/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieSigner {
    private static final String SIGNATURE = "&s=";
    private static final String SHA_STRING = "SHA-512";
    private byte[] secretBytes;
    private static final Logger LOG = LoggerFactory.getLogger(CookieSigner.class);

    public CookieSigner(byte[] secret) {
        if (secret == null) {
            throw new IllegalArgumentException(" NULL Secret Bytes");
        }
        this.secretBytes = (byte[])secret.clone();
    }

    public String signCookie(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        String signature = this.getSignature(str);
        LOG.debug("Signature generated for {} is {}", (Object)str, (Object)signature);
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) {
        int index = signedStr.lastIndexOf(SIGNATURE);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid input sign: " + signedStr);
        }
        String originalSignature = signedStr.substring(index + SIGNATURE.length());
        String rawValue = signedStr.substring(0, index);
        String currentSignature = this.getSignature(rawValue);
        LOG.debug("Signature generated for {} inside verify is {}", (Object)rawValue, (Object)currentSignature);
        if (!MessageDigest.isEqual(originalSignature.getBytes(), currentSignature.getBytes())) {
            throw new IllegalArgumentException("Invalid sign, original = " + originalSignature + " current = " + currentSignature);
        }
        return rawValue;
    }

    private String getSignature(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_STRING);
            md.update(str.getBytes());
            md.update(this.secretBytes);
            byte[] digest = md.digest();
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Invalid SHA digest String: SHA-512 " + ex.getMessage(), ex);
        }
    }
}

