/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;

class DBOriginalData
implements DBData {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] rawBytes_ = null;
    private int offset_ = -1;
    private int actualLength_ = -1;
    private boolean dataCompressed_ = false;
    private int rowCount_ = -1;
    private int columnCount_ = -1;
    private int indicatorSize_ = -1;
    private int rowSize_ = -1;
    private int indicatorOffset_ = -1;
    private int dataOffset_ = -1;
    private int length_ = -1;
    private int aliasCount_ = 0;

    public DBOriginalData(int n, boolean bl) {
        this.actualLength_ = n;
        this.dataCompressed_ = bl;
    }

    public DBOriginalData(int n, int n2, int n3, int n4) throws DBDataStreamException {
        this.rowCount_ = n;
        this.columnCount_ = n2;
        this.indicatorSize_ = n3;
        this.rowSize_ = n4;
        this.length_ = 14 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
    }

    public void overlay(byte[] byArray, int n) {
        this.offset_ = n;
        if (this.rowCount_ == -1) {
            this.rowCount_ = BinaryConverter.byteArrayToInt(byArray, this.offset_ + 4);
            this.columnCount_ = BinaryConverter.byteArrayToShort(byArray, this.offset_ + 8);
            this.indicatorSize_ = BinaryConverter.byteArrayToShort(byArray, this.offset_ + 10);
            this.rowSize_ = BinaryConverter.byteArrayToShort(byArray, this.offset_ + 12);
            this.length_ = 14 + this.rowCount_ * (this.columnCount_ * this.indicatorSize_ + this.rowSize_);
            if (this.dataCompressed_) {
                byte[] byArray2 = new byte[this.length_];
                System.arraycopy(byArray, this.offset_, byArray2, 0, 14);
                JDUtilities.decompress(byArray, this.offset_ + 14, this.actualLength_ - 20, byArray2, 14);
                this.rawBytes_ = byArray2;
                this.indicatorOffset_ = 14;
            } else {
                this.rawBytes_ = byArray;
                this.indicatorOffset_ = this.offset_ + 14;
            }
        } else {
            this.rawBytes_ = byArray;
            this.indicatorOffset_ = this.offset_ + 14;
            this.setRowCount(this.rowCount_);
            this.setColumnCount(this.columnCount_);
            this.setIndicatorSize(this.indicatorSize_);
            this.setRowSize(this.rowSize_);
        }
        this.dataOffset_ = this.indicatorOffset_ + this.rowCount_ * this.columnCount_ * this.indicatorSize_;
    }

    public int getLength() {
        return this.length_;
    }

    public int getConsistencyToken() {
        return BinaryConverter.byteArrayToInt(this.rawBytes_, this.offset_);
    }

    public int getRowCount() {
        return this.rowCount_;
    }

    public int getColumnCount() {
        return this.columnCount_;
    }

    public int getIndicatorSize() {
        return this.indicatorSize_;
    }

    public int getRowSize() {
        return this.rowSize_;
    }

    public int getIndicator(int n, int n2) {
        if (this.indicatorSize_ == 0) {
            return 0;
        }
        return BinaryConverter.byteArrayToShort(this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * ((n + this.aliasCount_) * this.columnCount_ + n2));
    }

    public int getRowDataOffset(int n) {
        return this.dataOffset_ + (n + this.aliasCount_) * this.rowSize_;
    }

    public byte[] getRawBytes() {
        return this.rawBytes_;
    }

    public void setConsistencyToken(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_);
    }

    public void setRowCount(int n) {
        BinaryConverter.intToByteArray(n, this.rawBytes_, this.offset_ + 4);
    }

    public void setColumnCount(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 8);
    }

    public void setIndicatorSize(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 10);
    }

    public void setRowSize(int n) {
        BinaryConverter.shortToByteArray((short)n, this.rawBytes_, this.offset_ + 12);
    }

    public void setIndicator(int n, int n2, int n3) {
        if (this.indicatorSize_ != 0) {
            BinaryConverter.shortToByteArray((short)n3, this.rawBytes_, this.indicatorOffset_ + this.indicatorSize_ * (n * this.columnCount_ + n2));
        }
    }

    public boolean isVariableFieldsCompressed() {
        return false;
    }

    public void resetRowCount(int n) {
        this.rowCount_ = n;
    }

    public void setAliasCount(int n) {
        this.aliasCount_ = n;
    }

    public int getIndicator(int n, int n2, int n3) {
        return -9999;
    }

    public int getDataTotalSize(int n) {
        return -9999;
    }

    public void logInformation(String string) {
        JDTrace.logInformation(this, string + "offset_=" + this.offset_);
        JDTrace.logInformation(this, string + "actualLength_=" + this.actualLength_);
        JDTrace.logInformation(this, string + "dataCompressed_=" + this.dataCompressed_);
        JDTrace.logInformation(this, string + "rowCount_=" + this.rowCount_);
        JDTrace.logInformation(this, string + "columnCount_=" + this.columnCount_);
        JDTrace.logInformation(this, string + "indicatorSize_=" + this.indicatorSize_);
        JDTrace.logInformation(this, string + "rowSize_=" + this.rowSize_);
        JDTrace.logInformation(this, string + "indicatorOffset_=" + this.indicatorOffset_);
        JDTrace.logInformation(this, string + "dataOffset_=" + this.dataOffset_);
        JDTrace.logInformation(this, string + "length_=" + this.length_);
        JDTrace.logInformation(this, string + "aliasCount_=" + this.aliasCount_);
    }
}

