/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.RowFilter;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.AutoValue_BigtableReadOptions;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
abstract class BigtableReadOptions
implements Serializable {
    BigtableReadOptions() {
    }

    abstract @Nullable ValueProvider<RowFilter> getRowFilter();

    abstract @Nullable ValueProvider<List<ByteKeyRange>> getKeyRanges();

    abstract @Nullable Integer getMaxBufferElementCount();

    abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_BigtableReadOptions.Builder();
    }

    BigtableReadOptions setMaxBufferElementCount(@Nullable Integer maxBufferElementCount) {
        return this.toBuilder().setMaxBufferElementCount(maxBufferElementCount).build();
    }

    BigtableReadOptions withRowFilter(RowFilter rowFilter) {
        return this.toBuilder().setRowFilter((ValueProvider<RowFilter>)ValueProvider.StaticValueProvider.of((Object)rowFilter)).build();
    }

    BigtableReadOptions withKeyRanges(List<ByteKeyRange> keyRanges) {
        return this.toBuilder().setKeyRanges((ValueProvider<List<ByteKeyRange>>)ValueProvider.StaticValueProvider.of(keyRanges)).build();
    }

    BigtableReadOptions withKeyRange(ByteKeyRange keyRange) {
        return this.withKeyRanges(Collections.singletonList(keyRange));
    }

    void populateDisplayData(DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"rowFilter", this.getRowFilter()).withLabel("Row Filter")).addIfNotNull(DisplayData.item((String)"keyRanges", this.getKeyRanges()).withLabel("Key Ranges"));
    }

    void validate() {
        if (this.getRowFilter() != null && this.getRowFilter().isAccessible()) {
            Preconditions.checkArgument((this.getRowFilter().get() != null ? 1 : 0) != 0, (Object)"rowFilter can not be null");
        }
        if (this.getMaxBufferElementCount() != null) {
            Preconditions.checkArgument((this.getMaxBufferElementCount() > 0 ? 1 : 0) != 0, (Object)"maxBufferElementCount can not be zero or negative");
        }
        if (this.getKeyRanges() != null && this.getKeyRanges().isAccessible()) {
            Preconditions.checkArgument((this.getKeyRanges().get() != null ? 1 : 0) != 0, (Object)"keyRanges can not be null");
            Preconditions.checkArgument((!((List)this.getKeyRanges().get()).isEmpty() ? 1 : 0) != 0, (Object)"keyRanges can not be empty");
            for (ByteKeyRange range : (List)this.getKeyRanges().get()) {
                Preconditions.checkArgument((range != null ? 1 : 0) != 0, (Object)"keyRanges cannot hold null range");
            }
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setRowFilter(ValueProvider<RowFilter> var1);

        abstract Builder setMaxBufferElementCount(@Nullable Integer var1);

        abstract Builder setKeyRanges(ValueProvider<List<ByteKeyRange>> var1);

        abstract BigtableReadOptions build();
    }
}

